/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;
import io.nem.symbol.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Addresses;
import io.nem.symbol.sdk.openapi.vertx.model.AliasTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespacePage;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceRegistrationTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NamespaceRoutesApiImpl
implements NamespaceRoutesApi {
    private ApiClient apiClient;

    public NamespaceRoutesApiImpl() {
        this(null);
    }

    public NamespaceRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void getAccountsNames(Addresses addresses, Handler<AsyncResult<AccountsNamesDTO>> resultHandler) {
        Addresses localVarBody = addresses;
        if (addresses == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'addresses' when calling getAccountsNames"));
            return;
        }
        String localVarPath = "/namespaces/account/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<AccountsNamesDTO> localVarReturnType = new TypeReference<AccountsNamesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaicsNames(MosaicIds mosaicIds, Handler<AsyncResult<MosaicsNamesDTO>> resultHandler) {
        MosaicIds localVarBody = mosaicIds;
        if (mosaicIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicIds' when calling getMosaicsNames"));
            return;
        }
        String localVarPath = "/namespaces/mosaic/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MosaicsNamesDTO> localVarReturnType = new TypeReference<MosaicsNamesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getNamespace(String namespaceId, Handler<AsyncResult<NamespaceInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespace"));
            return;
        }
        String localVarPath = "/namespaces/{namespaceId}".replaceAll("\\{namespaceId\\}", namespaceId.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<NamespaceInfoDTO> localVarReturnType = new TypeReference<NamespaceInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getNamespacesNames(NamespaceIds namespaceIds, Handler<AsyncResult<List<NamespaceNameDTO>>> resultHandler) {
        NamespaceIds localVarBody = namespaceIds;
        if (namespaceIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceIds' when calling getNamespacesNames"));
            return;
        }
        String localVarPath = "/namespaces/names";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<NamespaceNameDTO>> localVarReturnType = new TypeReference<List<NamespaceNameDTO>>(){};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void searchNamespaces(String ownerAddress, NamespaceRegistrationTypeEnum registrationType, String level0, AliasTypeEnum aliasType, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<NamespacePage>> resultHandler) {
        Object localVarBody = null;
        String localVarPath = "/namespaces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ownerAddress", ownerAddress));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "registrationType", (Object)registrationType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "level0", level0));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "aliasType", (Object)aliasType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<NamespacePage> localVarReturnType = new TypeReference<NamespacePage>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}

