package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AnnounceTransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Cosignature;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionIds;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPage;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPayload;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionTypeEnum;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-08-14T13:44:00.718Z[UTC]")
public class TransactionRoutesApiImpl implements TransactionRoutesApi {

    private ApiClient apiClient;

    public TransactionRoutesApiImpl() {
        this(null);
    }

    public TransactionRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Announce a cosignature transaction
     * Announces a cosignature transaction to the network.
     * @param cosignature  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announceCosignatureTransaction(Cosignature cosignature, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        Object localVarBody = cosignature;
        
        // verify the required parameter 'cosignature' is set
        if (cosignature == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'cosignature' when calling announceCosignatureTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transactions/cosignature";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AnnounceTransactionInfoDTO> localVarReturnType = new TypeReference<AnnounceTransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Announce an aggregate bonded transaction
     * Announces an aggregate bonded transaction to the network.
     * @param transactionPayload  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announcePartialTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        Object localVarBody = transactionPayload;
        
        // verify the required parameter 'transactionPayload' is set
        if (transactionPayload == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionPayload' when calling announcePartialTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transactions/partial";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AnnounceTransactionInfoDTO> localVarReturnType = new TypeReference<AnnounceTransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Announce a new transaction
     * Announces a transaction to the network. The [catbuffer library](https://github.com/nemtech/catbuffer) defines the protocol to serialize and deserialize Symbol entities. Catbuffers are integrated into [Symbol SDKs](https://nemtech.github.io/sdk.html).  It&#39;s recommended to use SDKs instead of calling the API endpoint directly to announce transactions. 
     * @param transactionPayload  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announceTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        Object localVarBody = transactionPayload;
        
        // verify the required parameter 'transactionPayload' is set
        if (transactionPayload == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionPayload' when calling announceTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transactions";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AnnounceTransactionInfoDTO> localVarReturnType = new TypeReference<AnnounceTransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get confirmed transaction information
     * Returns confirmed transaction information given a transactionId or hash.
     * @param transactionId Transaction id or hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getConfirmedTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'transactionId' is set
        if (transactionId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionId' when calling getConfirmedTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transactions/confirmed/{transactionId}".replaceAll("\\{" + "transactionId" + "\\}", transactionId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<TransactionInfoDTO> localVarReturnType = new TypeReference<TransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get confirmed trasactions information
     * Returns confirmed transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getConfirmedTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = transactionIds;
        
        // verify the required parameter 'transactionIds' is set
        if (transactionIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionIds' when calling getConfirmedTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transactions/confirmed";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get partial transaction information
     * Returns partial transaction information given a transactionId or hash.
     * @param transactionId Transaction id or hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getPartialTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'transactionId' is set
        if (transactionId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionId' when calling getPartialTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transactions/partial/{transactionId}".replaceAll("\\{" + "transactionId" + "\\}", transactionId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<TransactionInfoDTO> localVarReturnType = new TypeReference<TransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get partial trasactions information
     * Returns partial transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getPartialTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = transactionIds;
        
        // verify the required parameter 'transactionIds' is set
        if (transactionIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionIds' when calling getPartialTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transactions/partial";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get unconfirmed transaction information
     * Returns unconfirmed transaction information given a transactionId or hash.
     * @param transactionId Transaction id or hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getUnconfirmedTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'transactionId' is set
        if (transactionId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionId' when calling getUnconfirmedTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transactions/unconfirmed/{transactionId}".replaceAll("\\{" + "transactionId" + "\\}", transactionId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<TransactionInfoDTO> localVarReturnType = new TypeReference<TransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get unconfirmed trasactions information
     * Returns unconfirmed transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getUnconfirmedTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = transactionIds;
        
        // verify the required parameter 'transactionIds' is set
        if (transactionIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionIds' when calling getUnconfirmedTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transactions/unconfirmed";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Search confirmed transactions
     * Returns an array of confirmed transactions.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is consider to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param height Filter by block height. (optional, default to null)
     * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calcualate the block transactionsHash are returned.  (optional, default to false)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchConfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionPage>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/transactions/confirmed";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "address", address));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "recipientAddress", recipientAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "signerPublicKey", signerPublicKey));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
        localVarQueryParams.addAll(apiClient.parameterToPairs("multi", "type", type));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "embedded", embedded));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<TransactionPage> localVarReturnType = new TypeReference<TransactionPage>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Search partial transactions
     * Returns an array of partial transactions.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is consider to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param height Filter by block height. (optional, default to null)
     * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calcualate the block transactionsHash are returned.  (optional, default to false)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchPartialTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionPage>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/transactions/partial";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "address", address));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "recipientAddress", recipientAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "signerPublicKey", signerPublicKey));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
        localVarQueryParams.addAll(apiClient.parameterToPairs("multi", "type", type));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "embedded", embedded));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<TransactionPage> localVarReturnType = new TypeReference<TransactionPage>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Search unconfirmed transactions
     * Returns an array of unconfirmed transactions.
     * @param address Filter by address involved in the transaction.  An account&#39;s address is consider to be involved in the transaction when the account is the sender, recipient, or it is required to cosign the transaction. This filter cannot be combined with &#x60;&#x60;recipientAddress&#x60;&#x60; and &#x60;&#x60;signerPublicKey&#x60;&#x60; query params.  (optional)
     * @param recipientAddress Filter by address of the account receiving the transaction. (optional)
     * @param signerPublicKey Filter by public key of the account signing the entity. (optional)
     * @param height Filter by block height. (optional, default to null)
     * @param type Filter by transaction type. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param embedded When true, the endpoint also returns all the embedded aggregate transactions. Otherwise, only top-level transactions used to calcualate the block transactionsHash are returned.  (optional, default to false)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchUnconfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionPage>> resultHandler) {
        Object localVarBody = null;
        
        // create path and map variables
        String localVarPath = "/transactions/unconfirmed";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "address", address));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "recipientAddress", recipientAddress));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "signerPublicKey", signerPublicKey));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "height", height));
        localVarQueryParams.addAll(apiClient.parameterToPairs("multi", "type", type));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "embedded", embedded));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageNumber", pageNumber));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<TransactionPage> localVarReturnType = new TypeReference<TransactionPage>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
