package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.MetadataPage;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-07-22T16:03:29.279Z[UTC]")
public class MetadataRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi delegate;

	public MetadataRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get metadata entries
     * Returns an array of metadata.
     * @param sourceAddress Filter by address sending the metadata entry. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param scopedMetadataKey Filter by metadata key. (optional)
     * @param targetId Filter by namespace or mosaic id. (optional)
     * @param metadataType Filter by metadata type. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void searchMetadataEntries(String sourceAddress, String targetAddress, String scopedMetadataKey, String targetId, MetadataTypeEnum metadataType, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<MetadataPage>> resultHandler) {
        delegate.searchMetadataEntries(sourceAddress, targetAddress, scopedMetadataKey, targetId, metadataType, pageSize, pageNumber, offset, order, resultHandler);
    }

    /**
     * Get metadata entries
     * Returns an array of metadata.
     * @param sourceAddress Filter by address sending the metadata entry. (optional)
     * @param targetAddress Filter by target address. (optional)
     * @param scopedMetadataKey Filter by metadata key. (optional)
     * @param targetId Filter by namespace or mosaic id. (optional)
     * @param metadataType Filter by metadata type. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataPage> rxSearchMetadataEntries(String sourceAddress, String targetAddress, String scopedMetadataKey, String targetId, MetadataTypeEnum metadataType, Integer pageSize, Integer pageNumber, String offset, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchMetadataEntries(sourceAddress, targetAddress, scopedMetadataKey, targetId, metadataType, pageSize, pageNumber, offset, order, fut);
        }));
    }

    public static MetadataRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi arg) {
        return arg != null ? new MetadataRoutesApi(arg) : null;
    }
}
