package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AnnounceTransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Cosignature;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionIds;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPage;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPayload;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionTypeEnum;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface TransactionRoutesApi {

    void announceCosignatureTransaction(Cosignature cosignature, Handler<AsyncResult<AnnounceTransactionInfoDTO>> handler);

    void announcePartialTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> handler);

    void announceTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> handler);

    void getConfirmedTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> handler);

    void getConfirmedTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void getPartialTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> handler);

    void getPartialTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void getUnconfirmedTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> handler);

    void getUnconfirmedTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void searchConfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionPage>> handler);

    void searchPartialTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionPage>> handler);

    void searchUnconfirmedTransactions(String address, String recipientAddress, String signerPublicKey, java.math.BigInteger height, List<TransactionTypeEnum> type, Boolean embedded, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<TransactionPage>> handler);

}
