package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Addresses;
import io.nem.symbol.sdk.openapi.vertx.model.AliasTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespacePage;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceRegistrationTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface NamespaceRoutesApi {

    void getAccountsNames(Addresses addresses, Handler<AsyncResult<AccountsNamesDTO>> handler);

    void getMosaicsNames(MosaicIds mosaicIds, Handler<AsyncResult<MosaicsNamesDTO>> handler);

    void getNamespace(String namespaceId, Handler<AsyncResult<NamespaceInfoDTO>> handler);

    void getNamespacesNames(NamespaceIds namespaceIds, Handler<AsyncResult<List<NamespaceNameDTO>>> handler);

    void searchNamespaces(String ownerAddress, NamespaceRegistrationTypeEnum registrationType, String level0, AliasTypeEnum aliasType, Integer pageSize, Integer pageNumber, String offset, Order order, Handler<AsyncResult<NamespacePage>> handler);

}
