/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.1.2
 *
 * The version of the OpenAPI document: 0.9.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * MosaicMetadataTransactionBodyDTO
 */
@JsonPropertyOrder({
  MosaicMetadataTransactionBodyDTO.JSON_PROPERTY_TARGET_ADDRESS,
  MosaicMetadataTransactionBodyDTO.JSON_PROPERTY_SCOPED_METADATA_KEY,
  MosaicMetadataTransactionBodyDTO.JSON_PROPERTY_TARGET_MOSAIC_ID,
  MosaicMetadataTransactionBodyDTO.JSON_PROPERTY_VALUE_SIZE_DELTA,
  MosaicMetadataTransactionBodyDTO.JSON_PROPERTY_VALUE_SIZE,
  MosaicMetadataTransactionBodyDTO.JSON_PROPERTY_VALUE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class MosaicMetadataTransactionBodyDTO {
  public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
  private String targetAddress;

  public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
  private String scopedMetadataKey;

  public static final String JSON_PROPERTY_TARGET_MOSAIC_ID = "targetMosaicId";
  private String targetMosaicId;

  public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
  private Integer valueSizeDelta;

  public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
  private Long valueSize;

  public static final String JSON_PROPERTY_VALUE = "value";
  private String value;


  public MosaicMetadataTransactionBodyDTO targetAddress(String targetAddress) {
    
    this.targetAddress = targetAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. 
   * @return targetAddress
  **/
  @ApiModelProperty(example = "90340017CFF3DD2BCF3B2670CDCB9FC8C75754E2325F297C", required = true, value = "Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
  @JsonProperty(JSON_PROPERTY_TARGET_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetAddress() {
    return targetAddress;
  }


  public void setTargetAddress(String targetAddress) {
    this.targetAddress = targetAddress;
  }


  public MosaicMetadataTransactionBodyDTO scopedMetadataKey(String scopedMetadataKey) {
    
    this.scopedMetadataKey = scopedMetadataKey;
    return this;
  }

   /**
   * Metadata key scoped to source, target and type expressed.
   * @return scopedMetadataKey
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Metadata key scoped to source, target and type expressed.")
  @JsonProperty(JSON_PROPERTY_SCOPED_METADATA_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getScopedMetadataKey() {
    return scopedMetadataKey;
  }


  public void setScopedMetadataKey(String scopedMetadataKey) {
    this.scopedMetadataKey = scopedMetadataKey;
  }


  public MosaicMetadataTransactionBodyDTO targetMosaicId(String targetMosaicId) {
    
    this.targetMosaicId = targetMosaicId;
    return this;
  }

   /**
   * Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. 
   * @return targetMosaicId
  **/
  @ApiModelProperty(example = "85BBEA6CC462B244", required = true, value = "Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
  @JsonProperty(JSON_PROPERTY_TARGET_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetMosaicId() {
    return targetMosaicId;
  }


  public void setTargetMosaicId(String targetMosaicId) {
    this.targetMosaicId = targetMosaicId;
  }


  public MosaicMetadataTransactionBodyDTO valueSizeDelta(Integer valueSizeDelta) {
    
    this.valueSizeDelta = valueSizeDelta;
    return this;
  }

   /**
   * Change in value size in bytes.
   * @return valueSizeDelta
  **/
  @ApiModelProperty(required = true, value = "Change in value size in bytes.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getValueSizeDelta() {
    return valueSizeDelta;
  }


  public void setValueSizeDelta(Integer valueSizeDelta) {
    this.valueSizeDelta = valueSizeDelta;
  }


  public MosaicMetadataTransactionBodyDTO valueSize(Long valueSize) {
    
    this.valueSize = valueSize;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return valueSize
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getValueSize() {
    return valueSize;
  }


  public void setValueSize(Long valueSize) {
    this.valueSize = valueSize;
  }


  public MosaicMetadataTransactionBodyDTO value(String value) {
    
    this.value = value;
    return this;
  }

   /**
   * Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).
   * @return value
  **/
  @ApiModelProperty(required = true, value = "Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).")
  @JsonProperty(JSON_PROPERTY_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getValue() {
    return value;
  }


  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MosaicMetadataTransactionBodyDTO mosaicMetadataTransactionBodyDTO = (MosaicMetadataTransactionBodyDTO) o;
    return Objects.equals(this.targetAddress, mosaicMetadataTransactionBodyDTO.targetAddress) &&
        Objects.equals(this.scopedMetadataKey, mosaicMetadataTransactionBodyDTO.scopedMetadataKey) &&
        Objects.equals(this.targetMosaicId, mosaicMetadataTransactionBodyDTO.targetMosaicId) &&
        Objects.equals(this.valueSizeDelta, mosaicMetadataTransactionBodyDTO.valueSizeDelta) &&
        Objects.equals(this.valueSize, mosaicMetadataTransactionBodyDTO.valueSize) &&
        Objects.equals(this.value, mosaicMetadataTransactionBodyDTO.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(targetAddress, scopedMetadataKey, targetMosaicId, valueSizeDelta, valueSize, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MosaicMetadataTransactionBodyDTO {\n");
    sb.append("    targetAddress: ").append(toIndentedString(targetAddress)).append("\n");
    sb.append("    scopedMetadataKey: ").append(toIndentedString(scopedMetadataKey)).append("\n");
    sb.append("    targetMosaicId: ").append(toIndentedString(targetMosaicId)).append("\n");
    sb.append("    valueSizeDelta: ").append(toIndentedString(valueSizeDelta)).append("\n");
    sb.append("    valueSize: ").append(toIndentedString(valueSize)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

