/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.1.2
 *
 * The version of the OpenAPI document: 0.9.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.EmbeddedTransactionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountModificationTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * EmbeddedMultisigAccountModificationTransactionDTO
 */
@JsonPropertyOrder({
  EmbeddedMultisigAccountModificationTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  EmbeddedMultisigAccountModificationTransactionDTO.JSON_PROPERTY_VERSION,
  EmbeddedMultisigAccountModificationTransactionDTO.JSON_PROPERTY_NETWORK,
  EmbeddedMultisigAccountModificationTransactionDTO.JSON_PROPERTY_TYPE,
  EmbeddedMultisigAccountModificationTransactionDTO.JSON_PROPERTY_MIN_REMOVAL_DELTA,
  EmbeddedMultisigAccountModificationTransactionDTO.JSON_PROPERTY_MIN_APPROVAL_DELTA,
  EmbeddedMultisigAccountModificationTransactionDTO.JSON_PROPERTY_ADDRESS_ADDITIONS,
  EmbeddedMultisigAccountModificationTransactionDTO.JSON_PROPERTY_ADDRESS_DELETIONS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class EmbeddedMultisigAccountModificationTransactionDTO {
  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MIN_REMOVAL_DELTA = "minRemovalDelta";
  private Integer minRemovalDelta;

  public static final String JSON_PROPERTY_MIN_APPROVAL_DELTA = "minApprovalDelta";
  private Integer minApprovalDelta;

  public static final String JSON_PROPERTY_ADDRESS_ADDITIONS = "addressAdditions";
  private List<String> addressAdditions = new ArrayList<>();

  public static final String JSON_PROPERTY_ADDRESS_DELETIONS = "addressDeletions";
  private List<String> addressDeletions = new ArrayList<>();


  public EmbeddedMultisigAccountModificationTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public EmbeddedMultisigAccountModificationTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public EmbeddedMultisigAccountModificationTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public EmbeddedMultisigAccountModificationTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public EmbeddedMultisigAccountModificationTransactionDTO minRemovalDelta(Integer minRemovalDelta) {
    
    this.minRemovalDelta = minRemovalDelta;
    return this;
  }

   /**
   * Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. 
   * @return minRemovalDelta
  **/
  @ApiModelProperty(example = "1", required = true, value = "Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
  @JsonProperty(JSON_PROPERTY_MIN_REMOVAL_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinRemovalDelta() {
    return minRemovalDelta;
  }


  public void setMinRemovalDelta(Integer minRemovalDelta) {
    this.minRemovalDelta = minRemovalDelta;
  }


  public EmbeddedMultisigAccountModificationTransactionDTO minApprovalDelta(Integer minApprovalDelta) {
    
    this.minApprovalDelta = minApprovalDelta;
    return this;
  }

   /**
   * Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. 
   * @return minApprovalDelta
  **/
  @ApiModelProperty(example = "1", required = true, value = "Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
  @JsonProperty(JSON_PROPERTY_MIN_APPROVAL_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinApprovalDelta() {
    return minApprovalDelta;
  }


  public void setMinApprovalDelta(Integer minApprovalDelta) {
    this.minApprovalDelta = minApprovalDelta;
  }


  public EmbeddedMultisigAccountModificationTransactionDTO addressAdditions(List<String> addressAdditions) {
    
    this.addressAdditions = addressAdditions;
    return this;
  }

  public EmbeddedMultisigAccountModificationTransactionDTO addAddressAdditionsItem(String addressAdditionsItem) {
    this.addressAdditions.add(addressAdditionsItem);
    return this;
  }

   /**
   * Array of cosignatory accounts to add.
   * @return addressAdditions
  **/
  @ApiModelProperty(required = true, value = "Array of cosignatory accounts to add.")
  @JsonProperty(JSON_PROPERTY_ADDRESS_ADDITIONS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getAddressAdditions() {
    return addressAdditions;
  }


  public void setAddressAdditions(List<String> addressAdditions) {
    this.addressAdditions = addressAdditions;
  }


  public EmbeddedMultisigAccountModificationTransactionDTO addressDeletions(List<String> addressDeletions) {
    
    this.addressDeletions = addressDeletions;
    return this;
  }

  public EmbeddedMultisigAccountModificationTransactionDTO addAddressDeletionsItem(String addressDeletionsItem) {
    this.addressDeletions.add(addressDeletionsItem);
    return this;
  }

   /**
   * Array of cosignatory accounts to delete.
   * @return addressDeletions
  **/
  @ApiModelProperty(required = true, value = "Array of cosignatory accounts to delete.")
  @JsonProperty(JSON_PROPERTY_ADDRESS_DELETIONS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getAddressDeletions() {
    return addressDeletions;
  }


  public void setAddressDeletions(List<String> addressDeletions) {
    this.addressDeletions = addressDeletions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmbeddedMultisigAccountModificationTransactionDTO embeddedMultisigAccountModificationTransactionDTO = (EmbeddedMultisigAccountModificationTransactionDTO) o;
    return Objects.equals(this.signerPublicKey, embeddedMultisigAccountModificationTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, embeddedMultisigAccountModificationTransactionDTO.version) &&
        Objects.equals(this.network, embeddedMultisigAccountModificationTransactionDTO.network) &&
        Objects.equals(this.type, embeddedMultisigAccountModificationTransactionDTO.type) &&
        Objects.equals(this.minRemovalDelta, embeddedMultisigAccountModificationTransactionDTO.minRemovalDelta) &&
        Objects.equals(this.minApprovalDelta, embeddedMultisigAccountModificationTransactionDTO.minApprovalDelta) &&
        Objects.equals(this.addressAdditions, embeddedMultisigAccountModificationTransactionDTO.addressAdditions) &&
        Objects.equals(this.addressDeletions, embeddedMultisigAccountModificationTransactionDTO.addressDeletions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signerPublicKey, version, network, type, minRemovalDelta, minApprovalDelta, addressAdditions, addressDeletions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddedMultisigAccountModificationTransactionDTO {\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    minRemovalDelta: ").append(toIndentedString(minRemovalDelta)).append("\n");
    sb.append("    minApprovalDelta: ").append(toIndentedString(minApprovalDelta)).append("\n");
    sb.append("    addressAdditions: ").append(toIndentedString(addressAdditions)).append("\n");
    sb.append("    addressDeletions: ").append(toIndentedString(addressDeletions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

