/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.1.2
 *
 * The version of the OpenAPI document: 0.9.4
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.BlockDTOAllOf;
import io.nem.symbol.sdk.openapi.vertx.model.EntityDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.SizePrefixedEntityDTO;
import io.nem.symbol.sdk.openapi.vertx.model.VerifiableEntityDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * BlockDTO
 */
@JsonPropertyOrder({
  BlockDTO.JSON_PROPERTY_SIZE,
  BlockDTO.JSON_PROPERTY_SIGNATURE,
  BlockDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  BlockDTO.JSON_PROPERTY_VERSION,
  BlockDTO.JSON_PROPERTY_NETWORK,
  BlockDTO.JSON_PROPERTY_TYPE,
  BlockDTO.JSON_PROPERTY_HEIGHT,
  BlockDTO.JSON_PROPERTY_TIMESTAMP,
  BlockDTO.JSON_PROPERTY_DIFFICULTY,
  BlockDTO.JSON_PROPERTY_PROOF_GAMMA,
  BlockDTO.JSON_PROPERTY_PROOF_VERIFICATION_HASH,
  BlockDTO.JSON_PROPERTY_PROOF_SCALAR,
  BlockDTO.JSON_PROPERTY_PREVIOUS_BLOCK_HASH,
  BlockDTO.JSON_PROPERTY_TRANSACTIONS_HASH,
  BlockDTO.JSON_PROPERTY_RECEIPTS_HASH,
  BlockDTO.JSON_PROPERTY_STATE_HASH,
  BlockDTO.JSON_PROPERTY_BENEFICIARY_ADDRESS,
  BlockDTO.JSON_PROPERTY_FEE_MULTIPLIER
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class BlockDTO {
  public static final String JSON_PROPERTY_SIZE = "size";
  private Long size;

  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private java.math.BigInteger height = null;

  public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
  private java.math.BigInteger timestamp = null;

  public static final String JSON_PROPERTY_DIFFICULTY = "difficulty";
  private java.math.BigInteger difficulty = null;

  public static final String JSON_PROPERTY_PROOF_GAMMA = "proofGamma";
  private String proofGamma;

  public static final String JSON_PROPERTY_PROOF_VERIFICATION_HASH = "proofVerificationHash";
  private String proofVerificationHash;

  public static final String JSON_PROPERTY_PROOF_SCALAR = "proofScalar";
  private String proofScalar;

  public static final String JSON_PROPERTY_PREVIOUS_BLOCK_HASH = "previousBlockHash";
  private String previousBlockHash;

  public static final String JSON_PROPERTY_TRANSACTIONS_HASH = "transactionsHash";
  private String transactionsHash;

  public static final String JSON_PROPERTY_RECEIPTS_HASH = "receiptsHash";
  private String receiptsHash;

  public static final String JSON_PROPERTY_STATE_HASH = "stateHash";
  private String stateHash;

  public static final String JSON_PROPERTY_BENEFICIARY_ADDRESS = "beneficiaryAddress";
  private String beneficiaryAddress;

  public static final String JSON_PROPERTY_FEE_MULTIPLIER = "feeMultiplier";
  private Long feeMultiplier;


  public BlockDTO size(Long size) {
    
    this.size = size;
    return this;
  }

   /**
   * A number that allows uint 32 values.
   * @return size
  **/
  @ApiModelProperty(example = "2222212828", required = true, value = "A number that allows uint 32 values.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getSize() {
    return size;
  }


  public void setSize(Long size) {
    this.size = size;
  }


  public BlockDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public BlockDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public BlockDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public BlockDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public BlockDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public BlockDTO height(java.math.BigInteger height) {
    
    this.height = height;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return height
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getHeight() {
    return height;
  }


  public void setHeight(java.math.BigInteger height) {
    this.height = height;
  }


  public BlockDTO timestamp(java.math.BigInteger timestamp) {
    
    this.timestamp = timestamp;
    return this;
  }

   /**
   * Get timestamp
   * @return timestamp
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TIMESTAMP)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getTimestamp() {
    return timestamp;
  }


  public void setTimestamp(java.math.BigInteger timestamp) {
    this.timestamp = timestamp;
  }


  public BlockDTO difficulty(java.math.BigInteger difficulty) {
    
    this.difficulty = difficulty;
    return this;
  }

   /**
   * Determines how hard is to harvest a new block, based on previous blocks.
   * @return difficulty
  **/
  @ApiModelProperty(example = "100000000000000", required = true, value = "Determines how hard is to harvest a new block, based on previous blocks.")
  @JsonProperty(JSON_PROPERTY_DIFFICULTY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDifficulty() {
    return difficulty;
  }


  public void setDifficulty(java.math.BigInteger difficulty) {
    this.difficulty = difficulty;
  }


  public BlockDTO proofGamma(String proofGamma) {
    
    this.proofGamma = proofGamma;
    return this;
  }

   /**
   * 32-bytes VRF proof gamma.
   * @return proofGamma
  **/
  @ApiModelProperty(example = "8D49594A96C31EC6C64305FB2CCB47AA7A4AC0A4F614442BB3684D2BF41F274E", required = true, value = "32-bytes VRF proof gamma.")
  @JsonProperty(JSON_PROPERTY_PROOF_GAMMA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProofGamma() {
    return proofGamma;
  }


  public void setProofGamma(String proofGamma) {
    this.proofGamma = proofGamma;
  }


  public BlockDTO proofVerificationHash(String proofVerificationHash) {
    
    this.proofVerificationHash = proofVerificationHash;
    return this;
  }

   /**
   * 16-bytes VRF proof verification hash.
   * @return proofVerificationHash
  **/
  @ApiModelProperty(example = "82FB583BFE3EE78805784D078F2547AE", required = true, value = "16-bytes VRF proof verification hash.")
  @JsonProperty(JSON_PROPERTY_PROOF_VERIFICATION_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProofVerificationHash() {
    return proofVerificationHash;
  }


  public void setProofVerificationHash(String proofVerificationHash) {
    this.proofVerificationHash = proofVerificationHash;
  }


  public BlockDTO proofScalar(String proofScalar) {
    
    this.proofScalar = proofScalar;
    return this;
  }

   /**
   * 32-bytes VRF proof scalar.
   * @return proofScalar
  **/
  @ApiModelProperty(example = "480175C83739B22C53EAECAA7E7F3B245F1DFAFA6B3AE5C1D0129502FCBAAD0C", required = true, value = "32-bytes VRF proof scalar.")
  @JsonProperty(JSON_PROPERTY_PROOF_SCALAR)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProofScalar() {
    return proofScalar;
  }


  public void setProofScalar(String proofScalar) {
    this.proofScalar = proofScalar;
  }


  public BlockDTO previousBlockHash(String previousBlockHash) {
    
    this.previousBlockHash = previousBlockHash;
    return this;
  }

   /**
   * Get previousBlockHash
   * @return previousBlockHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PREVIOUS_BLOCK_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPreviousBlockHash() {
    return previousBlockHash;
  }


  public void setPreviousBlockHash(String previousBlockHash) {
    this.previousBlockHash = previousBlockHash;
  }


  public BlockDTO transactionsHash(String transactionsHash) {
    
    this.transactionsHash = transactionsHash;
    return this;
  }

   /**
   * Get transactionsHash
   * @return transactionsHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TRANSACTIONS_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTransactionsHash() {
    return transactionsHash;
  }


  public void setTransactionsHash(String transactionsHash) {
    this.transactionsHash = transactionsHash;
  }


  public BlockDTO receiptsHash(String receiptsHash) {
    
    this.receiptsHash = receiptsHash;
    return this;
  }

   /**
   * Get receiptsHash
   * @return receiptsHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_RECEIPTS_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getReceiptsHash() {
    return receiptsHash;
  }


  public void setReceiptsHash(String receiptsHash) {
    this.receiptsHash = receiptsHash;
  }


  public BlockDTO stateHash(String stateHash) {
    
    this.stateHash = stateHash;
    return this;
  }

   /**
   * Get stateHash
   * @return stateHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STATE_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStateHash() {
    return stateHash;
  }


  public void setStateHash(String stateHash) {
    this.stateHash = stateHash;
  }


  public BlockDTO beneficiaryAddress(String beneficiaryAddress) {
    
    this.beneficiaryAddress = beneficiaryAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base.
   * @return beneficiaryAddress
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required = true, value = "Address expressed in hexadecimal base.")
  @JsonProperty(JSON_PROPERTY_BENEFICIARY_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBeneficiaryAddress() {
    return beneficiaryAddress;
  }


  public void setBeneficiaryAddress(String beneficiaryAddress) {
    this.beneficiaryAddress = beneficiaryAddress;
  }


  public BlockDTO feeMultiplier(Long feeMultiplier) {
    
    this.feeMultiplier = feeMultiplier;
    return this;
  }

   /**
   * Fee multiplier applied to transactions contained in block.
   * @return feeMultiplier
  **/
  @ApiModelProperty(example = "0", required = true, value = "Fee multiplier applied to transactions contained in block.")
  @JsonProperty(JSON_PROPERTY_FEE_MULTIPLIER)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getFeeMultiplier() {
    return feeMultiplier;
  }


  public void setFeeMultiplier(Long feeMultiplier) {
    this.feeMultiplier = feeMultiplier;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BlockDTO blockDTO = (BlockDTO) o;
    return Objects.equals(this.size, blockDTO.size) &&
        Objects.equals(this.signature, blockDTO.signature) &&
        Objects.equals(this.signerPublicKey, blockDTO.signerPublicKey) &&
        Objects.equals(this.version, blockDTO.version) &&
        Objects.equals(this.network, blockDTO.network) &&
        Objects.equals(this.type, blockDTO.type) &&
        Objects.equals(this.height, blockDTO.height) &&
        Objects.equals(this.timestamp, blockDTO.timestamp) &&
        Objects.equals(this.difficulty, blockDTO.difficulty) &&
        Objects.equals(this.proofGamma, blockDTO.proofGamma) &&
        Objects.equals(this.proofVerificationHash, blockDTO.proofVerificationHash) &&
        Objects.equals(this.proofScalar, blockDTO.proofScalar) &&
        Objects.equals(this.previousBlockHash, blockDTO.previousBlockHash) &&
        Objects.equals(this.transactionsHash, blockDTO.transactionsHash) &&
        Objects.equals(this.receiptsHash, blockDTO.receiptsHash) &&
        Objects.equals(this.stateHash, blockDTO.stateHash) &&
        Objects.equals(this.beneficiaryAddress, blockDTO.beneficiaryAddress) &&
        Objects.equals(this.feeMultiplier, blockDTO.feeMultiplier);
  }

  @Override
  public int hashCode() {
    return Objects.hash(size, signature, signerPublicKey, version, network, type, height, timestamp, difficulty, proofGamma, proofVerificationHash, proofScalar, previousBlockHash, transactionsHash, receiptsHash, stateHash, beneficiaryAddress, feeMultiplier);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BlockDTO {\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    difficulty: ").append(toIndentedString(difficulty)).append("\n");
    sb.append("    proofGamma: ").append(toIndentedString(proofGamma)).append("\n");
    sb.append("    proofVerificationHash: ").append(toIndentedString(proofVerificationHash)).append("\n");
    sb.append("    proofScalar: ").append(toIndentedString(proofScalar)).append("\n");
    sb.append("    previousBlockHash: ").append(toIndentedString(previousBlockHash)).append("\n");
    sb.append("    transactionsHash: ").append(toIndentedString(transactionsHash)).append("\n");
    sb.append("    receiptsHash: ").append(toIndentedString(receiptsHash)).append("\n");
    sb.append("    stateHash: ").append(toIndentedString(stateHash)).append("\n");
    sb.append("    beneficiaryAddress: ").append(toIndentedString(beneficiaryAddress)).append("\n");
    sb.append("    feeMultiplier: ").append(toIndentedString(feeMultiplier)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

