package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionHashes;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionStatusDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class TransactionStatusRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.TransactionStatusRoutesApi delegate;

	public TransactionStatusRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.TransactionStatusRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.TransactionStatusRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get transaction status
     * Returns the transaction status for a given hash.
     * @param hash Transaction hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransactionStatus(String hash, Handler<AsyncResult<TransactionStatusDTO>> resultHandler) {
        delegate.getTransactionStatus(hash, resultHandler);
    }

    /**
     * Get transaction status
     * Returns the transaction status for a given hash.
     * @param hash Transaction hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<TransactionStatusDTO> rxGetTransactionStatus(String hash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getTransactionStatus(hash, fut);
        }));
    }
    /**
     * Get transaction statuses
     * Returns an array of transaction statuses for a given array of transaction hashes.
     * @param transactionHashes  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransactionStatuses(TransactionHashes transactionHashes, Handler<AsyncResult<List<TransactionStatusDTO>>> resultHandler) {
        delegate.getTransactionStatuses(transactionHashes, resultHandler);
    }

    /**
     * Get transaction statuses
     * Returns an array of transaction statuses for a given array of transaction hashes.
     * @param transactionHashes  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionStatusDTO>> rxGetTransactionStatuses(TransactionHashes transactionHashes) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getTransactionStatuses(transactionHashes, fut);
        }));
    }

    public static TransactionStatusRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.TransactionStatusRoutesApi arg) {
        return arg != null ? new TransactionStatusRoutesApi(arg) : null;
    }
}
