package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespacesInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class NamespaceRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi delegate;

	public NamespaceRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountsNames(AccountIds accountIds, Handler<AsyncResult<AccountsNamesDTO>> resultHandler) {
        delegate.getAccountsNames(accountIds, resultHandler);
    }

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param accountIds  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountsNamesDTO> rxGetAccountsNames(AccountIds accountIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountsNames(accountIds, fut);
        }));
    }
    /**
     * Get readable names for a set of mosaics
     * Returns friendly names for mosaics.
     * @param mosaicIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicsNames(MosaicIds mosaicIds, Handler<AsyncResult<MosaicsNamesDTO>> resultHandler) {
        delegate.getMosaicsNames(mosaicIds, resultHandler);
    }

    /**
     * Get readable names for a set of mosaics
     * Returns friendly names for mosaics.
     * @param mosaicIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicsNamesDTO> rxGetMosaicsNames(MosaicIds mosaicIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicsNames(mosaicIds, fut);
        }));
    }
    /**
     * Get namespace information
     * Gets the namespace for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespace(String namespaceId, Handler<AsyncResult<NamespaceInfoDTO>> resultHandler) {
        delegate.getNamespace(namespaceId, resultHandler);
    }

    /**
     * Get namespace information
     * Gets the namespace for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NamespaceInfoDTO> rxGetNamespace(String namespaceId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespace(namespaceId, fut);
        }));
    }
    /**
     * Get namespaces created by an account
     * Gets an array of namespaces for a given account address.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespacesFromAccount(String accountId, Integer pageSize, String id, Handler<AsyncResult<NamespacesInfoDTO>> resultHandler) {
        delegate.getNamespacesFromAccount(accountId, pageSize, id, resultHandler);
    }

    /**
     * Get namespaces created by an account
     * Gets an array of namespaces for a given account address.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NamespacesInfoDTO> rxGetNamespacesFromAccount(String accountId, Integer pageSize, String id) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespacesFromAccount(accountId, pageSize, id, fut);
        }));
    }
    /**
     * Get namespaces for given array of addresses
     * Gets namespaces for a given array of addresses.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespacesFromAccounts(AccountIds accountIds, Handler<AsyncResult<NamespacesInfoDTO>> resultHandler) {
        delegate.getNamespacesFromAccounts(accountIds, resultHandler);
    }

    /**
     * Get namespaces for given array of addresses
     * Gets namespaces for a given array of addresses.
     * @param accountIds  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NamespacesInfoDTO> rxGetNamespacesFromAccounts(AccountIds accountIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespacesFromAccounts(accountIds, fut);
        }));
    }
    /**
     * Get readable names for a set of namespaces
     * Returns friendly names for namespaces.
     * @param namespaceIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespacesNames(NamespaceIds namespaceIds, Handler<AsyncResult<List<NamespaceNameDTO>>> resultHandler) {
        delegate.getNamespacesNames(namespaceIds, resultHandler);
    }

    /**
     * Get readable names for a set of namespaces
     * Returns friendly names for namespaces.
     * @param namespaceIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<NamespaceNameDTO>> rxGetNamespacesNames(NamespaceIds namespaceIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespacesNames(namespaceIds, fut);
        }));
    }

    public static NamespaceRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.NamespaceRoutesApi arg) {
        return arg != null ? new NamespaceRoutesApi(arg) : null;
    }
}
