package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.MetadataDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataEntriesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class MetadataRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi delegate;

	public MetadataRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get account metadata
     * Returns the account metadata given an account id.
     * @param address Account address. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMetadata(String address, Integer pageSize, Order order, String id, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getAccountMetadata(address, pageSize, order, id, resultHandler);
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id.
     * @param address Account address. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetAccountMetadata(String address, Integer pageSize, Order order, String id) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMetadata(address, pageSize, order, id, fut);
        }));
    }
    /**
     * Get account metadata
     * Returns the account metadata given an account id and a key.
     * @param address Account address. (required)
     * @param key Metadata key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMetadataByKey(String address, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getAccountMetadataByKey(address, key, resultHandler);
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id and a key.
     * @param address Account address. (required)
     * @param key Metadata key. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetAccountMetadataByKey(String address, String key) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMetadataByKey(address, key, fut);
        }));
    }
    /**
     * Get account metadata
     * Returns the account metadata given an account id, a key, and a sender.
     * @param address Account address. (required)
     * @param key Metadata key. (required)
     * @param sourceAddress Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMetadataByKeyAndSender(String address, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        delegate.getAccountMetadataByKeyAndSender(address, key, sourceAddress, resultHandler);
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id, a key, and a sender.
     * @param address Account address. (required)
     * @param key Metadata key. (required)
     * @param sourceAddress Account address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataDTO> rxGetAccountMetadataByKeyAndSender(String address, String key, String sourceAddress) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMetadataByKeyAndSender(address, key, sourceAddress, fut);
        }));
    }
    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id.
     * @param mosaicId Mosaic identifier. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMetadata(String mosaicId, Integer pageSize, String id, Order order, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getMosaicMetadata(mosaicId, pageSize, id, order, resultHandler);
    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id.
     * @param mosaicId Mosaic identifier. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetMosaicMetadata(String mosaicId, Integer pageSize, String id, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicMetadata(mosaicId, pageSize, id, order, fut);
        }));
    }
    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id and a key.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMetadataByKey(String mosaicId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getMosaicMetadataByKey(mosaicId, key, resultHandler);
    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id and a key.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetMosaicMetadataByKey(String mosaicId, String key) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicMetadataByKey(mosaicId, key, fut);
        }));
    }
    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id, a key, and a sender.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param sourceAddress Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMetadataByKeyAndSender(String mosaicId, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        delegate.getMosaicMetadataByKeyAndSender(mosaicId, key, sourceAddress, resultHandler);
    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id, a key, and a sender.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param sourceAddress Account address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataDTO> rxGetMosaicMetadataByKeyAndSender(String mosaicId, String key, String sourceAddress) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicMetadataByKeyAndSender(mosaicId, key, sourceAddress, fut);
        }));
    }
    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id.
     * @param namespaceId Namespace identifier. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMetadata(String namespaceId, Integer pageSize, String id, Order order, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getNamespaceMetadata(namespaceId, pageSize, id, order, resultHandler);
    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id.
     * @param namespaceId Namespace identifier. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetNamespaceMetadata(String namespaceId, Integer pageSize, String id, Order order) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespaceMetadata(namespaceId, pageSize, id, order, fut);
        }));
    }
    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id and a key.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMetadataByKey(String namespaceId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getNamespaceMetadataByKey(namespaceId, key, resultHandler);
    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id and a key.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetNamespaceMetadataByKey(String namespaceId, String key) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespaceMetadataByKey(namespaceId, key, fut);
        }));
    }
    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id, a key, and a sender.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param sourceAddress Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        delegate.getNamespaceMetadataByKeyAndSender(namespaceId, key, sourceAddress, resultHandler);
    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id, a key, and a sender.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param sourceAddress Account address. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataDTO> rxGetNamespaceMetadataByKeyAndSender(String namespaceId, String key, String sourceAddress) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespaceMetadataByKeyAndSender(namespaceId, key, sourceAddress, fut);
        }));
    }

    public static MetadataRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi arg) {
        return arg != null ? new MetadataRoutesApi(arg) : null;
    }
}
