package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.ChainScoreDTO;
import io.nem.symbol.sdk.openapi.vertx.model.HeightInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class ChainRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.ChainRoutesApi delegate;

	public ChainRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.ChainRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.ChainRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get the current height of the chain
     * Returns the current height of the blockchain.
     * @param resultHandler Asynchronous result handler
     */
    public void getChainHeight(Handler<AsyncResult<HeightInfoDTO>> resultHandler) {
        delegate.getChainHeight(resultHandler);
    }

    /**
     * Get the current height of the chain
     * Returns the current height of the blockchain.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<HeightInfoDTO> rxGetChainHeight() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getChainHeight(fut);
        }));
    }
    /**
     * Get the current score of the chain
     * Gets the current score of the blockchain. The higher the score, the better the chain. During synchronization, nodes try to get the best blockchain in the network.  The score for a block is derived from its difficulty and the time (in seconds) that has elapsed since the last block:      block score &#x3D; difficulty − time elapsed since last block 
     * @param resultHandler Asynchronous result handler
     */
    public void getChainScore(Handler<AsyncResult<ChainScoreDTO>> resultHandler) {
        delegate.getChainScore(resultHandler);
    }

    /**
     * Get the current score of the chain
     * Gets the current score of the blockchain. The higher the score, the better the chain. During synchronization, nodes try to get the best blockchain in the network.  The score for a block is derived from its difficulty and the time (in seconds) that has elapsed since the last block:      block score &#x3D; difficulty − time elapsed since last block 
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<ChainScoreDTO> rxGetChainScore() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getChainScore(fut);
        }));
    }

    public static ChainRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.ChainRoutesApi arg) {
        return arg != null ? new ChainRoutesApi(arg) : null;
    }
}
