package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.BlockOrderByEnum;
import io.nem.symbol.sdk.openapi.vertx.model.BlockPage;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class BlockRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.BlockRoutesApi delegate;

	public BlockRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.BlockRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.BlockRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockByHeight(java.math.BigInteger height, Handler<AsyncResult<BlockInfoDTO>> resultHandler) {
        delegate.getBlockByHeight(height, resultHandler);
    }

    /**
     * Get block information
     * Gets a block from the chain that has the given height.
     * @param height Block height. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<BlockInfoDTO> rxGetBlockByHeight(java.math.BigInteger height) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getBlockByHeight(height, fut);
        }));
    }
    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.transactionsHash) to verify if the transaction was included in the block. 
     * @param height Block height. (required)
     * @param hash Transaction hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMerkleTransaction(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        delegate.getMerkleTransaction(height, hash, resultHandler);
    }

    /**
     * Get the merkle path for a given a transaction and block
     * Returns the merkle path for a transaction included in a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.transactionsHash) to verify if the transaction was included in the block. 
     * @param height Block height. (required)
     * @param hash Transaction hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleProofInfoDTO> rxGetMerkleTransaction(java.math.BigInteger height, String hash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMerkleTransaction(height, hash, fut);
        }));
    }
    /**
     * Get blocks
     * Gets an array of bocks.
     * @param signerPublicKey Public key of the account signing the entity. (optional)
     * @param beneficiaryAddress Filter by beneficiary address. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param orderBy  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void searchBlocks(String signerPublicKey, String beneficiaryAddress, Integer pageSize, Integer pageNumber, String offset, Order order, BlockOrderByEnum orderBy, Handler<AsyncResult<BlockPage>> resultHandler) {
        delegate.searchBlocks(signerPublicKey, beneficiaryAddress, pageSize, pageNumber, offset, order, orderBy, resultHandler);
    }

    /**
     * Get blocks
     * Gets an array of bocks.
     * @param signerPublicKey Public key of the account signing the entity. (optional)
     * @param beneficiaryAddress Filter by beneficiary address. (optional)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param pageNumber Filter by page number. (optional, default to 1)
     * @param offset Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param orderBy  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<BlockPage> rxSearchBlocks(String signerPublicKey, String beneficiaryAddress, Integer pageSize, Integer pageNumber, String offset, Order order, BlockOrderByEnum orderBy) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.searchBlocks(signerPublicKey, beneficiaryAddress, pageSize, pageNumber, offset, order, orderBy, fut);
        }));
    }

    public static BlockRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.BlockRoutesApi arg) {
        return arg != null ? new BlockRoutesApi(arg) : null;
    }
}
