package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class AccountRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi delegate;

	public AccountRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountInfo(String accountId, Handler<AsyncResult<AccountInfoDTO>> resultHandler) {
        delegate.getAccountInfo(accountId, resultHandler);
    }

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountInfoDTO> rxGetAccountInfo(String accountId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountInfo(accountId, fut);
        }));
    }
    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountsInfo(AccountIds accountIds, Handler<AsyncResult<List<AccountInfoDTO>>> resultHandler) {
        delegate.getAccountsInfo(accountIds, resultHandler);
    }

    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<AccountInfoDTO>> rxGetAccountsInfo(AccountIds accountIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountsInfo(accountIds, fut);
        }));
    }

    public static AccountRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi arg) {
        return arg != null ? new AccountRoutesApi(arg) : null;
    }
}
