package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.MetadataDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataEntriesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class MetadataRoutesApiImpl implements MetadataRoutesApi {

    private ApiClient apiClient;

    public MetadataRoutesApiImpl() {
        this(null);
    }

    public MetadataRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id.
     * @param address Account address. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMetadata(String address, Integer pageSize, Order order, String id, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'address' is set
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountMetadata"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/account/{address}".replaceAll("\\{" + "address" + "\\}", address.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get account metadata
     * Returns the account metadata given an account id and a key.
     * @param address Account address. (required)
     * @param key Metadata key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMetadataByKey(String address, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'address' is set
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountMetadataByKey"));
            return;
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getAccountMetadataByKey"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/account/{address}/key/{key}".replaceAll("\\{" + "address" + "\\}", address.toString()).replaceAll("\\{" + "key" + "\\}", key.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get account metadata
     * Returns the account metadata given an account id, a key, and a sender.
     * @param address Account address. (required)
     * @param key Metadata key. (required)
     * @param sourceAddress Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMetadataByKeyAndSender(String address, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'address' is set
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountMetadataByKeyAndSender"));
            return;
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getAccountMetadataByKeyAndSender"));
            return;
        }
        
        // verify the required parameter 'sourceAddress' is set
        if (sourceAddress == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'sourceAddress' when calling getAccountMetadataByKeyAndSender"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/account/{address}/key/{key}/sender/{sourceAddress}".replaceAll("\\{" + "address" + "\\}", address.toString()).replaceAll("\\{" + "key" + "\\}", key.toString()).replaceAll("\\{" + "sourceAddress" + "\\}", sourceAddress.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataDTO> localVarReturnType = new TypeReference<MetadataDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id.
     * @param mosaicId Mosaic identifier. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMetadata(String mosaicId, Integer pageSize, String id, Order order, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadata"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/mosaic/{mosaicId}".replaceAll("\\{" + "mosaicId" + "\\}", mosaicId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id and a key.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMetadataByKey(String mosaicId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKey"));
            return;
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKey"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}".replaceAll("\\{" + "mosaicId" + "\\}", mosaicId.toString()).replaceAll("\\{" + "key" + "\\}", key.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id, a key, and a sender.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param sourceAddress Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMetadataByKeyAndSender(String mosaicId, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKeyAndSender"));
            return;
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKeyAndSender"));
            return;
        }
        
        // verify the required parameter 'sourceAddress' is set
        if (sourceAddress == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'sourceAddress' when calling getMosaicMetadataByKeyAndSender"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}/sender/{sourceAddress}".replaceAll("\\{" + "mosaicId" + "\\}", mosaicId.toString()).replaceAll("\\{" + "key" + "\\}", key.toString()).replaceAll("\\{" + "sourceAddress" + "\\}", sourceAddress.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataDTO> localVarReturnType = new TypeReference<MetadataDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id.
     * @param namespaceId Namespace identifier. (required)
     * @param pageSize Select the number of entries to return. (optional, default to 10)
     * @param id Entry id at which to start pagination. If the ordering parameter is set to -id, the elements returned precede the identifier. Otherwise, newer elements with respect to the id are returned.  (optional)
     * @param order Sort responses in ascending or descending order based on the collection property set on the param &#x60;&#x60;orderBy&#x60;&#x60;. If the request does not specify &#x60;&#x60;orderBy&#x60;&#x60;, REST returns the collection ordered by id.  (optional, default to desc)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMetadata(String namespaceId, Integer pageSize, String id, Order order, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadata"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/namespace/{namespaceId}".replaceAll("\\{" + "namespaceId" + "\\}", namespaceId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "order", order));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id and a key.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMetadataByKey(String namespaceId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKey"));
            return;
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKey"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}".replaceAll("\\{" + "namespaceId" + "\\}", namespaceId.toString()).replaceAll("\\{" + "key" + "\\}", key.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id, a key, and a sender.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param sourceAddress Account address. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKeyAndSender"));
            return;
        }
        
        // verify the required parameter 'key' is set
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKeyAndSender"));
            return;
        }
        
        // verify the required parameter 'sourceAddress' is set
        if (sourceAddress == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'sourceAddress' when calling getNamespaceMetadataByKeyAndSender"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}/sender/{sourceAddress}".replaceAll("\\{" + "namespaceId" + "\\}", namespaceId.toString()).replaceAll("\\{" + "key" + "\\}", key.toString()).replaceAll("\\{" + "sourceAddress" + "\\}", sourceAddress.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MetadataDTO> localVarReturnType = new TypeReference<MetadataDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
