package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.MetadataDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataEntriesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface MetadataRoutesApi {

    void getAccountMetadata(String address, Integer pageSize, Order order, String id, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getAccountMetadataByKey(String address, String key, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getAccountMetadataByKeyAndSender(String address, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> handler);

    void getMosaicMetadata(String mosaicId, Integer pageSize, String id, Order order, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getMosaicMetadataByKey(String mosaicId, String key, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getMosaicMetadataByKeyAndSender(String mosaicId, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> handler);

    void getNamespaceMetadata(String namespaceId, Integer pageSize, String id, Order order, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getNamespaceMetadataByKey(String namespaceId, String key, Handler<AsyncResult<MetadataEntriesDTO>> handler);

    void getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> handler);

}
