package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-06-30T14:26:53.226Z[UTC]")
public class AccountRoutesApiImpl implements AccountRoutesApi {

    private ApiClient apiClient;

    public AccountRoutesApiImpl() {
        this(null);
    }

    public AccountRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountInfo(String accountId, Handler<AsyncResult<AccountInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountInfo"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AccountInfoDTO> localVarReturnType = new TypeReference<AccountInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountsInfo(AccountIds accountIds, Handler<AsyncResult<List<AccountInfoDTO>>> resultHandler) {
        Object localVarBody = accountIds;
        
        // create path and map variables
        String localVarPath = "/account";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<AccountInfoDTO>> localVarReturnType = new TypeReference<List<AccountInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
