/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataEntriesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Order;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;

public class MetadataRoutesApiImpl
implements MetadataRoutesApi {
    private ApiClient apiClient;

    public MetadataRoutesApiImpl() {
        this(null);
    }

    public MetadataRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void getAccountMetadata(String address, Integer pageSize, Order order, String id, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountMetadata"));
            return;
        }
        String localVarPath = "/metadata/account/{address}".replaceAll("\\{address\\}", address.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getAccountMetadataByKey(String address, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountMetadataByKey"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getAccountMetadataByKey"));
            return;
        }
        String localVarPath = "/metadata/account/{address}/key/{key}".replaceAll("\\{address\\}", address.toString()).replaceAll("\\{key\\}", key.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getAccountMetadataByKeyAndSender(String address, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        Object localVarBody = null;
        if (address == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'address' when calling getAccountMetadataByKeyAndSender"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getAccountMetadataByKeyAndSender"));
            return;
        }
        if (sourceAddress == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'sourceAddress' when calling getAccountMetadataByKeyAndSender"));
            return;
        }
        String localVarPath = "/metadata/account/{address}/key/{key}/sender/{sourceAddress}".replaceAll("\\{address\\}", address.toString()).replaceAll("\\{key\\}", key.toString()).replaceAll("\\{sourceAddress\\}", sourceAddress.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataDTO> localVarReturnType = new TypeReference<MetadataDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaicMetadata(String mosaicId, Integer pageSize, String id, Order order, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadata"));
            return;
        }
        String localVarPath = "/metadata/mosaic/{mosaicId}".replaceAll("\\{mosaicId\\}", mosaicId.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaicMetadataByKey(String mosaicId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKey"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKey"));
            return;
        }
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}".replaceAll("\\{mosaicId\\}", mosaicId.toString()).replaceAll("\\{key\\}", key.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaicMetadataByKeyAndSender(String mosaicId, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        Object localVarBody = null;
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKeyAndSender"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKeyAndSender"));
            return;
        }
        if (sourceAddress == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'sourceAddress' when calling getMosaicMetadataByKeyAndSender"));
            return;
        }
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}/sender/{sourceAddress}".replaceAll("\\{mosaicId\\}", mosaicId.toString()).replaceAll("\\{key\\}", key.toString()).replaceAll("\\{sourceAddress\\}", sourceAddress.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataDTO> localVarReturnType = new TypeReference<MetadataDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getNamespaceMetadata(String namespaceId, Integer pageSize, String id, Order order, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadata"));
            return;
        }
        String localVarPath = "/metadata/namespace/{namespaceId}".replaceAll("\\{namespaceId\\}", namespaceId.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "order", (Object)order));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getNamespaceMetadataByKey(String namespaceId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKey"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKey"));
            return;
        }
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}".replaceAll("\\{namespaceId\\}", namespaceId.toString()).replaceAll("\\{key\\}", key.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String sourceAddress, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        Object localVarBody = null;
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKeyAndSender"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKeyAndSender"));
            return;
        }
        if (sourceAddress == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'sourceAddress' when calling getNamespaceMetadataByKeyAndSender"));
            return;
        }
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}/sender/{sourceAddress}".replaceAll("\\{namespaceId\\}", namespaceId.toString()).replaceAll("\\{key\\}", key.toString()).replaceAll("\\{sourceAddress\\}", sourceAddress.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataDTO> localVarReturnType = new TypeReference<MetadataDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}

