/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.invoker;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;
import io.nem.symbol.sdk.openapi.vertx.invoker.RFC3339DateFormat;
import io.nem.symbol.sdk.openapi.vertx.invoker.StringUtil;
import io.nem.symbol.sdk.openapi.vertx.invoker.auth.ApiKeyAuth;
import io.nem.symbol.sdk.openapi.vertx.invoker.auth.Authentication;
import io.nem.symbol.sdk.openapi.vertx.invoker.auth.HttpBasicAuth;
import io.nem.symbol.sdk.openapi.vertx.invoker.auth.HttpBearerAuth;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ApiClient {
    private static final Pattern CONTENT_DISPOSITION_PATTERN = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?");
    private static final OpenOptions FILE_DOWNLOAD_OPTIONS = new OpenOptions().setCreate(true).setTruncateExisting(true);
    private final Vertx vertx;
    private final JsonObject config;
    private final String identifier;
    private MultiMap defaultHeaders = MultiMap.caseInsensitiveMultiMap();
    private MultiMap defaultCookies = MultiMap.caseInsensitiveMultiMap();
    private Map<String, Authentication> authentications;
    private String basePath = "http://localhost:3000";
    private DateFormat dateFormat;
    private ObjectMapper objectMapper;
    private String downloadsDir = "";

    public ApiClient(Vertx vertx, JsonObject config) {
        Objects.requireNonNull(vertx, "Vertx must not be null");
        Objects.requireNonNull(config, "Config must not be null");
        this.vertx = vertx;
        this.dateFormat = new RFC3339DateFormat();
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.setDateFormat(this.dateFormat);
        JsonNullableModule jnm = new JsonNullableModule();
        this.objectMapper.registerModule((Module)jnm);
        this.authentications = new HashMap<String, Authentication>();
        this.authentications = Collections.unmodifiableMap(this.authentications);
        this.basePath = config.getString("basePath", this.basePath);
        this.downloadsDir = config.getString("downloadsDir", this.downloadsDir);
        this.config = config;
        this.identifier = UUID.randomUUID().toString();
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ApiClient setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public synchronized WebClient getWebClient() {
        String webClientIdentifier = "web-client-" + this.identifier;
        WebClient webClient = (WebClient)Vertx.currentContext().get(webClientIdentifier);
        if (webClient == null) {
            webClient = this.buildWebClient(this.vertx, this.config);
            Vertx.currentContext().put(webClientIdentifier, (Object)webClient);
        }
        return webClient;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public String getDownloadsDir() {
        return this.downloadsDir;
    }

    public ApiClient setDownloadsDir(String downloadsDir) {
        this.downloadsDir = downloadsDir;
        return this;
    }

    public MultiMap getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaders.add(key, value);
        return this;
    }

    public MultiMap getDefaultCookies() {
        return this.defaultHeaders;
    }

    public ApiClient addDefaultCookie(String key, String value) {
        this.defaultCookies.add(key, value);
        return this;
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public ApiClient setBearerToken(String bearerToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBearerAuth)) continue;
            ((HttpBearerAuth)auth).setBearerToken(bearerToken);
            return this;
        }
        throw new RuntimeException("No Bearer authentication configured!");
    }

    public ApiClient setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return this;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public ApiClient setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return this;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public ApiClient setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return this;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public ApiClient setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return this;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        String format;
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        Collection valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = format = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if ("multi".equals(format)) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if ("csv".equals(format)) {
            delimiter = ",";
        } else if ("ssv".equals(format)) {
            delimiter = " ";
        } else if ("tsv".equals(format)) {
            delimiter = "\t";
        } else if ("pipes".equals(format)) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    private boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equalsIgnoreCase("application/json-patch+json"));
    }

    protected String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    protected String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public void sendBody(HttpRequest<Buffer> request, Handler<AsyncResult<HttpResponse<Buffer>>> responseHandler, Object body) {
        if (body instanceof byte[]) {
            Buffer buffer = Buffer.buffer((byte[])((byte[])body));
            request.sendBuffer(buffer, responseHandler);
        } else if (body instanceof AsyncFile) {
            AsyncFile file = (AsyncFile)body;
            request.sendStream((ReadStream)file, responseHandler);
        } else {
            request.sendJson(body, responseHandler);
        }
    }

    public <T> void invokeAPI(String path, String method, List<Pair> queryParams, Object body, MultiMap headerParams, MultiMap cookieParams, Map<String, Object> formParams, String[] accepts, String[] contentTypes, String[] authNames, TypeReference<T> returnType, Handler<AsyncResult<T>> resultHandler) {
        this.updateParamsForAuth(authNames, queryParams, headerParams, cookieParams);
        if (accepts != null && accepts.length > 0) {
            headerParams.add(HttpHeaders.ACCEPT, (CharSequence)this.selectHeaderAccept(accepts));
        }
        if (contentTypes != null) {
            headerParams.add(HttpHeaders.CONTENT_TYPE, (CharSequence)this.selectHeaderContentType(contentTypes));
        }
        HttpMethod httpMethod = HttpMethod.valueOf((String)method);
        HttpRequest request = this.getWebClient().requestAbs(httpMethod, this.basePath + path);
        if (httpMethod == HttpMethod.PATCH) {
            request.putHeader("X-HTTP-Method-Override", "PATCH");
        }
        queryParams.forEach(entry -> {
            if (entry.getValue() != null) {
                request.addQueryParam(entry.getName(), entry.getValue());
            }
        });
        headerParams.forEach(entry -> {
            if (entry.getValue() != null) {
                request.putHeader((String)entry.getKey(), (String)entry.getValue());
            }
        });
        this.defaultHeaders.forEach(entry -> {
            if (entry.getValue() != null) {
                request.putHeader((String)entry.getKey(), (String)entry.getValue());
            }
        });
        MultiMap cookies = MultiMap.caseInsensitiveMultiMap().addAll(cookieParams).addAll(this.defaultCookies);
        request.putHeader("Cookie", this.buildCookieHeader(cookies));
        Handler<AsyncResult<HttpResponse<Buffer>>> responseHandler = this.buildResponseHandler(returnType, resultHandler);
        if (body != null) {
            this.sendBody((HttpRequest<Buffer>)request, responseHandler, body);
        } else if (formParams != null && !formParams.isEmpty()) {
            Map<String, String> formMap = formParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.parameterToString(entry.getValue())));
            MultiMap form = MultiMap.caseInsensitiveMultiMap().addAll(formMap);
            request.sendForm(form, responseHandler);
        } else {
            request.send(responseHandler);
        }
    }

    private String buildCookieHeader(MultiMap cookies) {
        StringBuilder cookieValue = new StringBuilder();
        String delimiter = "";
        for (Map.Entry entry : cookies.entries()) {
            if (entry.getValue() == null) continue;
            cookieValue.append(String.format("%s%s=%s", delimiter, entry.getKey(), entry.getValue()));
            delimiter = "; ";
        }
        return cookieValue.toString();
    }

    protected String sanitizeFilename(String filename) {
        return filename.replaceAll(".*[/\\\\]", "");
    }

    protected String generateFilename(MultiMap headers) {
        Matcher matcher;
        String filename = UUID.randomUUID().toString();
        String contentDisposition = headers.get("Content-Disposition");
        if (contentDisposition != null && !contentDisposition.isEmpty() && (matcher = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition)).find()) {
            filename = this.sanitizeFilename(matcher.group(1));
        }
        return filename;
    }

    protected <T> void handleFileDownload(HttpResponse<Buffer> response, Handler<AsyncResult<T>> handler) {
        FileSystem fs = this.getVertx().fileSystem();
        String filename = this.generateFilename(response.headers());
        Consumer<String> fileHandler = directory -> fs.open(directory + filename, FILE_DOWNLOAD_OPTIONS, asyncFileResult -> {
            if (asyncFileResult.succeeded()) {
                AsyncFile asyncFile = (AsyncFile)asyncFileResult.result();
                asyncFile.write(response.bodyAsBuffer());
                handler.handle((Object)Future.succeededFuture((Object)asyncFile));
            } else {
                handler.handle(ApiException.fail(asyncFileResult.cause()));
            }
        });
        String dir = this.getDownloadsDir();
        if (dir != null && !dir.isEmpty()) {
            fs.mkdirs(dir, mkdirResult -> {
                String sanitizedFolder = dir.endsWith("/") ? dir : dir + "/";
                fileHandler.accept(sanitizedFolder);
            });
        } else {
            fileHandler.accept("");
        }
    }

    protected <T> Handler<AsyncResult<HttpResponse<Buffer>>> buildResponseHandler(TypeReference<T> returnType, Handler<AsyncResult<T>> handler) {
        return response -> {
            AsyncResult result;
            if (response.succeeded()) {
                HttpResponse httpResponse = (HttpResponse)response.result();
                if (httpResponse.statusCode() / 100 == 2) {
                    if (httpResponse.statusCode() == 204 || returnType == null) {
                        result = Future.succeededFuture(null);
                    } else {
                        Object resultContent = null;
                        if ("byte[]".equals(returnType.getType().toString())) {
                            resultContent = ((Buffer)httpResponse.body()).getBytes();
                            result = Future.succeededFuture((Object)resultContent);
                        } else {
                            if (AsyncFile.class.equals((Object)returnType.getType())) {
                                this.handleFileDownload((HttpResponse<Buffer>)httpResponse, handler);
                                return;
                            }
                            try {
                                resultContent = this.objectMapper.readValue(httpResponse.bodyAsString(), returnType);
                                result = Future.succeededFuture((Object)resultContent);
                            }
                            catch (Exception e) {
                                result = ApiException.fail((Throwable)new DecodeException("Failed to decode:" + e.getMessage(), (Throwable)e));
                            }
                        }
                    }
                } else {
                    result = ApiException.fail(httpResponse.statusMessage(), httpResponse.statusCode(), httpResponse.headers(), httpResponse.bodyAsString());
                }
            } else {
                result = response.cause() instanceof ApiException ? Future.failedFuture((Throwable)response.cause()) : ApiException.fail(500, response.cause() != null ? response.cause().getMessage() : null);
            }
            handler.handle(result);
        };
    }

    protected WebClient buildWebClient(Vertx vertx, JsonObject config) {
        if (!config.containsKey("userAgent")) {
            config.put("userAgent", "OpenAPI-Generator/0.8.9/java");
        }
        return WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions(config));
    }

    protected void updateParamsForAuth(String[] authNames, List<Pair> queryParams, MultiMap headerParams, MultiMap cookieParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams, cookieParams);
        }
    }
}

