/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.symbol.sdk.openapi.vertx.api.BlockRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;
import io.nem.symbol.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BlockRoutesApiImpl
implements BlockRoutesApi {
    private ApiClient apiClient;

    public BlockRoutesApiImpl() {
        this(null);
    }

    public BlockRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void getBlockByHeight(BigInteger height, Handler<AsyncResult<BlockInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getBlockByHeight"));
            return;
        }
        String localVarPath = "/block/{height}".replaceAll("\\{height\\}", height.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<BlockInfoDTO> localVarReturnType = new TypeReference<BlockInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getBlockTransactions(BigInteger height, Integer pageSize, String id, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getBlockTransactions"));
            return;
        }
        String localVarPath = "/block/{height}/transactions".replaceAll("\\{height\\}", height.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getBlocksByHeightWithLimit(BigInteger height, Integer limit, Handler<AsyncResult<List<BlockInfoDTO>>> resultHandler) {
        Object localVarBody = null;
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getBlocksByHeightWithLimit"));
            return;
        }
        if (limit == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'limit' when calling getBlocksByHeightWithLimit"));
            return;
        }
        String localVarPath = "/blocks/{height}/limit/{limit}".replaceAll("\\{height\\}", height.toString()).replaceAll("\\{limit\\}", limit.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<BlockInfoDTO>> localVarReturnType = new TypeReference<List<BlockInfoDTO>>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMerkleTransaction(BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (height == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'height' when calling getMerkleTransaction"));
            return;
        }
        if (hash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'hash' when calling getMerkleTransaction"));
            return;
        }
        String localVarPath = "/block/{height}/transaction/{hash}/merkle".replaceAll("\\{height\\}", height.toString()).replaceAll("\\{hash\\}", hash.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MerkleProofInfoDTO> localVarReturnType = new TypeReference<MerkleProofInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}

