/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountPublicKey", "accountAddress", "minApproval", "minRemoval", "cosignatoryPublicKeys", "multisigPublicKeys"})
public class MultisigDTO {
    public static final String JSON_PROPERTY_ACCOUNT_PUBLIC_KEY = "accountPublicKey";
    private String accountPublicKey;
    public static final String JSON_PROPERTY_ACCOUNT_ADDRESS = "accountAddress";
    private String accountAddress;
    public static final String JSON_PROPERTY_MIN_APPROVAL = "minApproval";
    private Integer minApproval;
    public static final String JSON_PROPERTY_MIN_REMOVAL = "minRemoval";
    private Integer minRemoval;
    public static final String JSON_PROPERTY_COSIGNATORY_PUBLIC_KEYS = "cosignatoryPublicKeys";
    private List<String> cosignatoryPublicKeys = new ArrayList<String>();
    public static final String JSON_PROPERTY_MULTISIG_PUBLIC_KEYS = "multisigPublicKeys";
    private List<String> multisigPublicKeys = new ArrayList<String>();

    public MultisigDTO accountPublicKey(String accountPublicKey) {
        this.accountPublicKey = accountPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="accountPublicKey")
    public String getAccountPublicKey() {
        return this.accountPublicKey;
    }

    public void setAccountPublicKey(String accountPublicKey) {
        this.accountPublicKey = accountPublicKey;
    }

    public MultisigDTO accountAddress(String accountAddress) {
        this.accountAddress = accountAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required=true, value="Address expressed in hexadecimal base.")
    @JsonProperty(value="accountAddress")
    public String getAccountAddress() {
        return this.accountAddress;
    }

    public void setAccountAddress(String accountAddress) {
        this.accountAddress = accountAddress;
    }

    public MultisigDTO minApproval(Integer minApproval) {
        this.minApproval = minApproval;
        return this;
    }

    @ApiModelProperty(example="2", required=true, value="Number of signatures needed to approve a transaction.")
    @JsonProperty(value="minApproval")
    public Integer getMinApproval() {
        return this.minApproval;
    }

    public void setMinApproval(Integer minApproval) {
        this.minApproval = minApproval;
    }

    public MultisigDTO minRemoval(Integer minRemoval) {
        this.minRemoval = minRemoval;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of signatures needed to remove a cosignatory.")
    @JsonProperty(value="minRemoval")
    public Integer getMinRemoval() {
        return this.minRemoval;
    }

    public void setMinRemoval(Integer minRemoval) {
        this.minRemoval = minRemoval;
    }

    public MultisigDTO cosignatoryPublicKeys(List<String> cosignatoryPublicKeys) {
        this.cosignatoryPublicKeys = cosignatoryPublicKeys;
        return this;
    }

    public MultisigDTO addCosignatoryPublicKeysItem(String cosignatoryPublicKeysItem) {
        this.cosignatoryPublicKeys.add(cosignatoryPublicKeysItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of public keys of the cosignatory accounts.")
    @JsonProperty(value="cosignatoryPublicKeys")
    public List<String> getCosignatoryPublicKeys() {
        return this.cosignatoryPublicKeys;
    }

    public void setCosignatoryPublicKeys(List<String> cosignatoryPublicKeys) {
        this.cosignatoryPublicKeys = cosignatoryPublicKeys;
    }

    public MultisigDTO multisigPublicKeys(List<String> multisigPublicKeys) {
        this.multisigPublicKeys = multisigPublicKeys;
        return this;
    }

    public MultisigDTO addMultisigPublicKeysItem(String multisigPublicKeysItem) {
        this.multisigPublicKeys.add(multisigPublicKeysItem);
        return this;
    }

    @ApiModelProperty(example="[\"565059F55E68F904214E8BE1D610B5BBEA4CE46CC13D246D45BC1DAE5D32A0D2\"]", required=true, value="Array of multisig accounts where the account is cosignatory.")
    @JsonProperty(value="multisigPublicKeys")
    public List<String> getMultisigPublicKeys() {
        return this.multisigPublicKeys;
    }

    public void setMultisigPublicKeys(List<String> multisigPublicKeys) {
        this.multisigPublicKeys = multisigPublicKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultisigDTO multisigDTO = (MultisigDTO)o;
        return Objects.equals(this.accountPublicKey, multisigDTO.accountPublicKey) && Objects.equals(this.accountAddress, multisigDTO.accountAddress) && Objects.equals(this.minApproval, multisigDTO.minApproval) && Objects.equals(this.minRemoval, multisigDTO.minRemoval) && Objects.equals(this.cosignatoryPublicKeys, multisigDTO.cosignatoryPublicKeys) && Objects.equals(this.multisigPublicKeys, multisigDTO.multisigPublicKeys);
    }

    public int hashCode() {
        return Objects.hash(this.accountPublicKey, this.accountAddress, this.minApproval, this.minRemoval, this.cosignatoryPublicKeys, this.multisigPublicKeys);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultisigDTO {\n");
        sb.append("    accountPublicKey: ").append(this.toIndentedString(this.accountPublicKey)).append("\n");
        sb.append("    accountAddress: ").append(this.toIndentedString(this.accountAddress)).append("\n");
        sb.append("    minApproval: ").append(this.toIndentedString(this.minApproval)).append("\n");
        sb.append("    minRemoval: ").append(this.toIndentedString(this.minRemoval)).append("\n");
        sb.append("    cosignatoryPublicKeys: ").append(this.toIndentedString(this.cosignatoryPublicKeys)).append("\n");
        sb.append("    multisigPublicKeys: ").append(this.toIndentedString(this.multisigPublicKeys)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

