/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.22
 *
 * The version of the OpenAPI document: 0.8.7
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountModificationTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Transaction to create or modify a multisig account.
 */
@ApiModel(description = "Transaction to create or modify a multisig account.")
@JsonPropertyOrder({
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_SIGNATURE,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_VERSION,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_NETWORK,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_TYPE,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_MAX_FEE,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_DEADLINE,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_MIN_REMOVAL_DELTA,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_MIN_APPROVAL_DELTA,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_PUBLIC_KEY_ADDITIONS,
  MultisigAccountModificationTransactionDTO.JSON_PROPERTY_PUBLIC_KEY_DELETIONS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T21:11:31.580Z[UTC]")
public class MultisigAccountModificationTransactionDTO {
  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private String maxFee;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private String deadline;

  public static final String JSON_PROPERTY_MIN_REMOVAL_DELTA = "minRemovalDelta";
  private Integer minRemovalDelta;

  public static final String JSON_PROPERTY_MIN_APPROVAL_DELTA = "minApprovalDelta";
  private Integer minApprovalDelta;

  public static final String JSON_PROPERTY_PUBLIC_KEY_ADDITIONS = "publicKeyAdditions";
  private List<String> publicKeyAdditions = new ArrayList<>();

  public static final String JSON_PROPERTY_PUBLIC_KEY_DELETIONS = "publicKeyDeletions";
  private List<String> publicKeyDeletions = new ArrayList<>();


  public MultisigAccountModificationTransactionDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public MultisigAccountModificationTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public MultisigAccountModificationTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public MultisigAccountModificationTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public MultisigAccountModificationTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public MultisigAccountModificationTransactionDTO maxFee(String maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(String maxFee) {
    this.maxFee = maxFee;
  }


  public MultisigAccountModificationTransactionDTO deadline(String deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDeadline() {
    return deadline;
  }


  public void setDeadline(String deadline) {
    this.deadline = deadline;
  }


  public MultisigAccountModificationTransactionDTO minRemovalDelta(Integer minRemovalDelta) {
    
    this.minRemovalDelta = minRemovalDelta;
    return this;
  }

   /**
   * Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. 
   * @return minRemovalDelta
  **/
  @ApiModelProperty(example = "1", required = true, value = "Number of signatures needed to remove a cosignatory. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
  @JsonProperty(JSON_PROPERTY_MIN_REMOVAL_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinRemovalDelta() {
    return minRemovalDelta;
  }


  public void setMinRemovalDelta(Integer minRemovalDelta) {
    this.minRemovalDelta = minRemovalDelta;
  }


  public MultisigAccountModificationTransactionDTO minApprovalDelta(Integer minApprovalDelta) {
    
    this.minApprovalDelta = minApprovalDelta;
    return this;
  }

   /**
   * Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. 
   * @return minApprovalDelta
  **/
  @ApiModelProperty(example = "1", required = true, value = "Number of signatures needed to approve a transaction. If we are modifying an existing multisig account, this indicates the relative change of the minimum cosignatories. ")
  @JsonProperty(JSON_PROPERTY_MIN_APPROVAL_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinApprovalDelta() {
    return minApprovalDelta;
  }


  public void setMinApprovalDelta(Integer minApprovalDelta) {
    this.minApprovalDelta = minApprovalDelta;
  }


  public MultisigAccountModificationTransactionDTO publicKeyAdditions(List<String> publicKeyAdditions) {
    
    this.publicKeyAdditions = publicKeyAdditions;
    return this;
  }

  public MultisigAccountModificationTransactionDTO addPublicKeyAdditionsItem(String publicKeyAdditionsItem) {
    this.publicKeyAdditions.add(publicKeyAdditionsItem);
    return this;
  }

   /**
   * Array of cosignatory accounts to add.
   * @return publicKeyAdditions
  **/
  @ApiModelProperty(required = true, value = "Array of cosignatory accounts to add.")
  @JsonProperty(JSON_PROPERTY_PUBLIC_KEY_ADDITIONS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getPublicKeyAdditions() {
    return publicKeyAdditions;
  }


  public void setPublicKeyAdditions(List<String> publicKeyAdditions) {
    this.publicKeyAdditions = publicKeyAdditions;
  }


  public MultisigAccountModificationTransactionDTO publicKeyDeletions(List<String> publicKeyDeletions) {
    
    this.publicKeyDeletions = publicKeyDeletions;
    return this;
  }

  public MultisigAccountModificationTransactionDTO addPublicKeyDeletionsItem(String publicKeyDeletionsItem) {
    this.publicKeyDeletions.add(publicKeyDeletionsItem);
    return this;
  }

   /**
   * Array of cosignatory accounts to delete.
   * @return publicKeyDeletions
  **/
  @ApiModelProperty(required = true, value = "Array of cosignatory accounts to delete.")
  @JsonProperty(JSON_PROPERTY_PUBLIC_KEY_DELETIONS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getPublicKeyDeletions() {
    return publicKeyDeletions;
  }


  public void setPublicKeyDeletions(List<String> publicKeyDeletions) {
    this.publicKeyDeletions = publicKeyDeletions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultisigAccountModificationTransactionDTO multisigAccountModificationTransactionDTO = (MultisigAccountModificationTransactionDTO) o;
    return Objects.equals(this.signature, multisigAccountModificationTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, multisigAccountModificationTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, multisigAccountModificationTransactionDTO.version) &&
        Objects.equals(this.network, multisigAccountModificationTransactionDTO.network) &&
        Objects.equals(this.type, multisigAccountModificationTransactionDTO.type) &&
        Objects.equals(this.maxFee, multisigAccountModificationTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, multisigAccountModificationTransactionDTO.deadline) &&
        Objects.equals(this.minRemovalDelta, multisigAccountModificationTransactionDTO.minRemovalDelta) &&
        Objects.equals(this.minApprovalDelta, multisigAccountModificationTransactionDTO.minApprovalDelta) &&
        Objects.equals(this.publicKeyAdditions, multisigAccountModificationTransactionDTO.publicKeyAdditions) &&
        Objects.equals(this.publicKeyDeletions, multisigAccountModificationTransactionDTO.publicKeyDeletions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signature, signerPublicKey, version, network, type, maxFee, deadline, minRemovalDelta, minApprovalDelta, publicKeyAdditions, publicKeyDeletions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultisigAccountModificationTransactionDTO {\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    minRemovalDelta: ").append(toIndentedString(minRemovalDelta)).append("\n");
    sb.append("    minApprovalDelta: ").append(toIndentedString(minApprovalDelta)).append("\n");
    sb.append("    publicKeyAdditions: ").append(toIndentedString(publicKeyAdditions)).append("\n");
    sb.append("    publicKeyDeletions: ").append(toIndentedString(publicKeyDeletions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

