package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.MetadataDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataEntriesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T21:11:31.580Z[UTC]")
public class MetadataRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi delegate;

	public MetadataRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get account metadata
     * Returns the account metadata given an account id.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMetadata(String accountId, Integer pageSize, String id, String ordering, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getAccountMetadata(accountId, pageSize, id, ordering, resultHandler);
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetAccountMetadata(String accountId, Integer pageSize, String id, String ordering) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMetadata(accountId, pageSize, id, ordering, fut);
        }));
    }
    /**
     * Get account metadata
     * Returns the account metadata given an account id and a key.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMetadataByKey(String accountId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getAccountMetadataByKey(accountId, key, resultHandler);
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id and a key.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetAccountMetadataByKey(String accountId, String key) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMetadataByKey(accountId, key, fut);
        }));
    }
    /**
     * Get account metadata
     * Returns the account metadata given an account id, a key, and a sender.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMetadataByKeyAndSender(String accountId, String key, String publicKey, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        delegate.getAccountMetadataByKeyAndSender(accountId, key, publicKey, resultHandler);
    }

    /**
     * Get account metadata
     * Returns the account metadata given an account id, a key, and a sender.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataDTO> rxGetAccountMetadataByKeyAndSender(String accountId, String key, String publicKey) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMetadataByKeyAndSender(accountId, key, publicKey, fut);
        }));
    }
    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id.
     * @param mosaicId Mosaic identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMetadata(String mosaicId, Integer pageSize, String id, String ordering, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getMosaicMetadata(mosaicId, pageSize, id, ordering, resultHandler);
    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id.
     * @param mosaicId Mosaic identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetMosaicMetadata(String mosaicId, Integer pageSize, String id, String ordering) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicMetadata(mosaicId, pageSize, id, ordering, fut);
        }));
    }
    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id and a key.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMetadataByKey(String mosaicId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getMosaicMetadataByKey(mosaicId, key, resultHandler);
    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id and a key.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetMosaicMetadataByKey(String mosaicId, String key) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicMetadataByKey(mosaicId, key, fut);
        }));
    }
    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id, a key, and a sender.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicMetadataByKeyAndSender(String mosaicId, String key, String publicKey, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        delegate.getMosaicMetadataByKeyAndSender(mosaicId, key, publicKey, resultHandler);
    }

    /**
     * Get mosaic metadata
     * Returns the mosaic metadata given a mosaic id, a key, and a sender.
     * @param mosaicId Mosaic identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataDTO> rxGetMosaicMetadataByKeyAndSender(String mosaicId, String key, String publicKey) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicMetadataByKeyAndSender(mosaicId, key, publicKey, fut);
        }));
    }
    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id.
     * @param namespaceId Namespace identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMetadata(String namespaceId, Integer pageSize, String id, String ordering, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getNamespaceMetadata(namespaceId, pageSize, id, ordering, resultHandler);
    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id.
     * @param namespaceId Namespace identifier. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Metadata identifier up to which metadata are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetNamespaceMetadata(String namespaceId, Integer pageSize, String id, String ordering) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespaceMetadata(namespaceId, pageSize, id, ordering, fut);
        }));
    }
    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id and a key.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMetadataByKey(String namespaceId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        delegate.getNamespaceMetadataByKey(namespaceId, key, resultHandler);
    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id and a key.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataEntriesDTO> rxGetNamespaceMetadataByKey(String namespaceId, String key) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespaceMetadataByKey(namespaceId, key, fut);
        }));
    }
    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id, a key, and a sender.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String publicKey, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        delegate.getNamespaceMetadataByKeyAndSender(namespaceId, key, publicKey, resultHandler);
    }

    /**
     * Get namespace metadata
     * Returns the namespace metadata given a namespace id, a key, and a sender.
     * @param namespaceId Namespace identifier. (required)
     * @param key Metadata key. (required)
     * @param publicKey Account public key. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MetadataDTO> rxGetNamespaceMetadataByKeyAndSender(String namespaceId, String key, String publicKey) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNamespaceMetadataByKeyAndSender(namespaceId, key, publicKey, fut);
        }));
    }

    public static MetadataRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi arg) {
        return arg != null ? new MetadataRoutesApi(arg) : null;
    }
}
