package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicAddressRestrictionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicGlobalRestrictionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T21:11:31.580Z[UTC]")
public class RestrictionMosaicRoutesApiImpl implements RestrictionMosaicRoutesApi {

    private ApiClient apiClient;

    public RestrictionMosaicRoutesApiImpl() {
        this(null);
    }

    public RestrictionMosaicRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get mosaic address restrictions for a given mosaic and account identifier.
     * Get mosaic address restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicAddressRestriction(String mosaicId, String accountId, Handler<AsyncResult<MosaicAddressRestrictionDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicAddressRestriction"));
            return;
        }
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getMosaicAddressRestriction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/restrictions/mosaic/{mosaicId}/address/{accountId}".replaceAll("\\{" + "mosaicId" + "\\}", mosaicId.toString()).replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MosaicAddressRestrictionDTO> localVarReturnType = new TypeReference<MosaicAddressRestrictionDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get mosaic address restrictions for a given mosaic and account identifiers array.
     * Get mosaic address restrictions.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicAddressRestrictions(String mosaicId, AccountIds accountIds, Handler<AsyncResult<List<MosaicAddressRestrictionDTO>>> resultHandler) {
        Object localVarBody = accountIds;
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicAddressRestrictions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/restrictions/mosaic/{mosaicId}".replaceAll("\\{" + "mosaicId" + "\\}", mosaicId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<MosaicAddressRestrictionDTO>> localVarReturnType = new TypeReference<List<MosaicAddressRestrictionDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get mosaic global restriction for a given mosaic identifier.
     * Get mosaic global restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicGlobalRestriction(String mosaicId, Handler<AsyncResult<MosaicGlobalRestrictionDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicGlobalRestriction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/restrictions/mosaic/{mosaicId}".replaceAll("\\{" + "mosaicId" + "\\}", mosaicId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MosaicGlobalRestrictionDTO> localVarReturnType = new TypeReference<MosaicGlobalRestrictionDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get mosaic global restrictions for an array of mosaics.
     * Get mosaic global restrictions.
     * @param mosaicIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicGlobalRestrictions(MosaicIds mosaicIds, Handler<AsyncResult<List<MosaicGlobalRestrictionDTO>>> resultHandler) {
        Object localVarBody = mosaicIds;
        
        // verify the required parameter 'mosaicIds' is set
        if (mosaicIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicIds' when calling getMosaicGlobalRestrictions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/restrictions/mosaic";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<MosaicGlobalRestrictionDTO>> localVarReturnType = new TypeReference<List<MosaicGlobalRestrictionDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
