/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.22
 *
 * The version of the OpenAPI document: 0.8.7
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceMetadataTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Transaction to create or modify a multisig account.
 */
@ApiModel(description = "Transaction to create or modify a multisig account.")
@JsonPropertyOrder({
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_SIGNATURE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_VERSION,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_NETWORK,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_TYPE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_MAX_FEE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_DEADLINE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_TARGET_PUBLIC_KEY,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_SCOPED_METADATA_KEY,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_TARGET_NAMESPACE_ID,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_VALUE_SIZE_DELTA,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_VALUE_SIZE,
  NamespaceMetadataTransactionDTO.JSON_PROPERTY_VALUE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T21:07:49.823Z[UTC]")
public class NamespaceMetadataTransactionDTO {
  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private String maxFee;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private String deadline;

  public static final String JSON_PROPERTY_TARGET_PUBLIC_KEY = "targetPublicKey";
  private String targetPublicKey;

  public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
  private String scopedMetadataKey;

  public static final String JSON_PROPERTY_TARGET_NAMESPACE_ID = "targetNamespaceId";
  private String targetNamespaceId;

  public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
  private Integer valueSizeDelta;

  public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
  private Integer valueSize;

  public static final String JSON_PROPERTY_VALUE = "value";
  private String value;


  public NamespaceMetadataTransactionDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public NamespaceMetadataTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public NamespaceMetadataTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public NamespaceMetadataTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public NamespaceMetadataTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public NamespaceMetadataTransactionDTO maxFee(String maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(String maxFee) {
    this.maxFee = maxFee;
  }


  public NamespaceMetadataTransactionDTO deadline(String deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDeadline() {
    return deadline;
  }


  public void setDeadline(String deadline) {
    this.deadline = deadline;
  }


  public NamespaceMetadataTransactionDTO targetPublicKey(String targetPublicKey) {
    
    this.targetPublicKey = targetPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return targetPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_TARGET_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetPublicKey() {
    return targetPublicKey;
  }


  public void setTargetPublicKey(String targetPublicKey) {
    this.targetPublicKey = targetPublicKey;
  }


  public NamespaceMetadataTransactionDTO scopedMetadataKey(String scopedMetadataKey) {
    
    this.scopedMetadataKey = scopedMetadataKey;
    return this;
  }

   /**
   * Metadata key scoped to source, target and type expressed.
   * @return scopedMetadataKey
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Metadata key scoped to source, target and type expressed.")
  @JsonProperty(JSON_PROPERTY_SCOPED_METADATA_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getScopedMetadataKey() {
    return scopedMetadataKey;
  }


  public void setScopedMetadataKey(String scopedMetadataKey) {
    this.scopedMetadataKey = scopedMetadataKey;
  }


  public NamespaceMetadataTransactionDTO targetNamespaceId(String targetNamespaceId) {
    
    this.targetNamespaceId = targetNamespaceId;
    return this;
  }

   /**
   * Namespace identifier.
   * @return targetNamespaceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "85BBEA6CC462B244", value = "Namespace identifier.")
  @JsonProperty(JSON_PROPERTY_TARGET_NAMESPACE_ID)
  // @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTargetNamespaceId() {
    return targetNamespaceId;
  }


  public void setTargetNamespaceId(String targetNamespaceId) {
    this.targetNamespaceId = targetNamespaceId;
  }


  public NamespaceMetadataTransactionDTO valueSizeDelta(Integer valueSizeDelta) {
    
    this.valueSizeDelta = valueSizeDelta;
    return this;
  }

   /**
   * Change in value size in bytes.
   * @return valueSizeDelta
  **/
  @ApiModelProperty(required = true, value = "Change in value size in bytes.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getValueSizeDelta() {
    return valueSizeDelta;
  }


  public void setValueSizeDelta(Integer valueSizeDelta) {
    this.valueSizeDelta = valueSizeDelta;
  }


  public NamespaceMetadataTransactionDTO valueSize(Integer valueSize) {
    
    this.valueSize = valueSize;
    return this;
  }

   /**
   * Value size in bytes.
   * @return valueSize
  **/
  @ApiModelProperty(required = true, value = "Value size in bytes.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getValueSize() {
    return valueSize;
  }


  public void setValueSize(Integer valueSize) {
    this.valueSize = valueSize;
  }


  public NamespaceMetadataTransactionDTO value(String value) {
    
    this.value = value;
    return this;
  }

   /**
   * Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).
   * @return value
  **/
  @ApiModelProperty(required = true, value = "Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).")
  @JsonProperty(JSON_PROPERTY_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getValue() {
    return value;
  }


  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NamespaceMetadataTransactionDTO namespaceMetadataTransactionDTO = (NamespaceMetadataTransactionDTO) o;
    return Objects.equals(this.signature, namespaceMetadataTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, namespaceMetadataTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, namespaceMetadataTransactionDTO.version) &&
        Objects.equals(this.network, namespaceMetadataTransactionDTO.network) &&
        Objects.equals(this.type, namespaceMetadataTransactionDTO.type) &&
        Objects.equals(this.maxFee, namespaceMetadataTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, namespaceMetadataTransactionDTO.deadline) &&
        Objects.equals(this.targetPublicKey, namespaceMetadataTransactionDTO.targetPublicKey) &&
        Objects.equals(this.scopedMetadataKey, namespaceMetadataTransactionDTO.scopedMetadataKey) &&
        Objects.equals(this.targetNamespaceId, namespaceMetadataTransactionDTO.targetNamespaceId) &&
        Objects.equals(this.valueSizeDelta, namespaceMetadataTransactionDTO.valueSizeDelta) &&
        Objects.equals(this.valueSize, namespaceMetadataTransactionDTO.valueSize) &&
        Objects.equals(this.value, namespaceMetadataTransactionDTO.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signature, signerPublicKey, version, network, type, maxFee, deadline, targetPublicKey, scopedMetadataKey, targetNamespaceId, valueSizeDelta, valueSize, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NamespaceMetadataTransactionDTO {\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    targetPublicKey: ").append(toIndentedString(targetPublicKey)).append("\n");
    sb.append("    scopedMetadataKey: ").append(toIndentedString(scopedMetadataKey)).append("\n");
    sb.append("    targetNamespaceId: ").append(toIndentedString(targetNamespaceId)).append("\n");
    sb.append("    valueSizeDelta: ").append(toIndentedString(valueSizeDelta)).append("\n");
    sb.append("    valueSize: ").append(toIndentedString(valueSize)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

