/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.22
 *
 * The version of the OpenAPI document: 0.8.7
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * MultisigDTO
 */
@JsonPropertyOrder({
  MultisigDTO.JSON_PROPERTY_ACCOUNT_PUBLIC_KEY,
  MultisigDTO.JSON_PROPERTY_ACCOUNT_ADDRESS,
  MultisigDTO.JSON_PROPERTY_MIN_APPROVAL,
  MultisigDTO.JSON_PROPERTY_MIN_REMOVAL,
  MultisigDTO.JSON_PROPERTY_COSIGNATORY_PUBLIC_KEYS,
  MultisigDTO.JSON_PROPERTY_MULTISIG_PUBLIC_KEYS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T21:07:49.823Z[UTC]")
public class MultisigDTO {
  public static final String JSON_PROPERTY_ACCOUNT_PUBLIC_KEY = "accountPublicKey";
  private String accountPublicKey;

  public static final String JSON_PROPERTY_ACCOUNT_ADDRESS = "accountAddress";
  private String accountAddress;

  public static final String JSON_PROPERTY_MIN_APPROVAL = "minApproval";
  private Integer minApproval;

  public static final String JSON_PROPERTY_MIN_REMOVAL = "minRemoval";
  private Integer minRemoval;

  public static final String JSON_PROPERTY_COSIGNATORY_PUBLIC_KEYS = "cosignatoryPublicKeys";
  private List<String> cosignatoryPublicKeys = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTISIG_PUBLIC_KEYS = "multisigPublicKeys";
  private List<String> multisigPublicKeys = new ArrayList<>();


  public MultisigDTO accountPublicKey(String accountPublicKey) {
    
    this.accountPublicKey = accountPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return accountPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountPublicKey() {
    return accountPublicKey;
  }


  public void setAccountPublicKey(String accountPublicKey) {
    this.accountPublicKey = accountPublicKey;
  }


  public MultisigDTO accountAddress(String accountAddress) {
    
    this.accountAddress = accountAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base.
   * @return accountAddress
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required = true, value = "Address expressed in hexadecimal base.")
  @JsonProperty(JSON_PROPERTY_ACCOUNT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getAccountAddress() {
    return accountAddress;
  }


  public void setAccountAddress(String accountAddress) {
    this.accountAddress = accountAddress;
  }


  public MultisigDTO minApproval(Integer minApproval) {
    
    this.minApproval = minApproval;
    return this;
  }

   /**
   * Number of signatures needed to approve a transaction.
   * @return minApproval
  **/
  @ApiModelProperty(example = "2", required = true, value = "Number of signatures needed to approve a transaction.")
  @JsonProperty(JSON_PROPERTY_MIN_APPROVAL)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinApproval() {
    return minApproval;
  }


  public void setMinApproval(Integer minApproval) {
    this.minApproval = minApproval;
  }


  public MultisigDTO minRemoval(Integer minRemoval) {
    
    this.minRemoval = minRemoval;
    return this;
  }

   /**
   * Number of signatures needed to remove a cosignatory.
   * @return minRemoval
  **/
  @ApiModelProperty(example = "1", required = true, value = "Number of signatures needed to remove a cosignatory.")
  @JsonProperty(JSON_PROPERTY_MIN_REMOVAL)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMinRemoval() {
    return minRemoval;
  }


  public void setMinRemoval(Integer minRemoval) {
    this.minRemoval = minRemoval;
  }


  public MultisigDTO cosignatoryPublicKeys(List<String> cosignatoryPublicKeys) {
    
    this.cosignatoryPublicKeys = cosignatoryPublicKeys;
    return this;
  }

  public MultisigDTO addCosignatoryPublicKeysItem(String cosignatoryPublicKeysItem) {
    this.cosignatoryPublicKeys.add(cosignatoryPublicKeysItem);
    return this;
  }

   /**
   * Array of public keys of the cosignatory accounts.
   * @return cosignatoryPublicKeys
  **/
  @ApiModelProperty(required = true, value = "Array of public keys of the cosignatory accounts.")
  @JsonProperty(JSON_PROPERTY_COSIGNATORY_PUBLIC_KEYS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getCosignatoryPublicKeys() {
    return cosignatoryPublicKeys;
  }


  public void setCosignatoryPublicKeys(List<String> cosignatoryPublicKeys) {
    this.cosignatoryPublicKeys = cosignatoryPublicKeys;
  }


  public MultisigDTO multisigPublicKeys(List<String> multisigPublicKeys) {
    
    this.multisigPublicKeys = multisigPublicKeys;
    return this;
  }

  public MultisigDTO addMultisigPublicKeysItem(String multisigPublicKeysItem) {
    this.multisigPublicKeys.add(multisigPublicKeysItem);
    return this;
  }

   /**
   * Array of multisig accounts where the account is cosignatory.
   * @return multisigPublicKeys
  **/
  @ApiModelProperty(example = "[\"565059F55E68F904214E8BE1D610B5BBEA4CE46CC13D246D45BC1DAE5D32A0D2\"]", required = true, value = "Array of multisig accounts where the account is cosignatory.")
  @JsonProperty(JSON_PROPERTY_MULTISIG_PUBLIC_KEYS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getMultisigPublicKeys() {
    return multisigPublicKeys;
  }


  public void setMultisigPublicKeys(List<String> multisigPublicKeys) {
    this.multisigPublicKeys = multisigPublicKeys;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MultisigDTO multisigDTO = (MultisigDTO) o;
    return Objects.equals(this.accountPublicKey, multisigDTO.accountPublicKey) &&
        Objects.equals(this.accountAddress, multisigDTO.accountAddress) &&
        Objects.equals(this.minApproval, multisigDTO.minApproval) &&
        Objects.equals(this.minRemoval, multisigDTO.minRemoval) &&
        Objects.equals(this.cosignatoryPublicKeys, multisigDTO.cosignatoryPublicKeys) &&
        Objects.equals(this.multisigPublicKeys, multisigDTO.multisigPublicKeys);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountPublicKey, accountAddress, minApproval, minRemoval, cosignatoryPublicKeys, multisigPublicKeys);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MultisigDTO {\n");
    sb.append("    accountPublicKey: ").append(toIndentedString(accountPublicKey)).append("\n");
    sb.append("    accountAddress: ").append(toIndentedString(accountAddress)).append("\n");
    sb.append("    minApproval: ").append(toIndentedString(minApproval)).append("\n");
    sb.append("    minRemoval: ").append(toIndentedString(minRemoval)).append("\n");
    sb.append("    cosignatoryPublicKeys: ").append(toIndentedString(cosignatoryPublicKeys)).append("\n");
    sb.append("    multisigPublicKeys: ").append(toIndentedString(multisigPublicKeys)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

