/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.22
 *
 * The version of the OpenAPI document: 0.8.7
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicAddressRestrictionTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Transaction to set a restriction rule to an address.
 */
@ApiModel(description = "Transaction to set a restriction rule to an address.")
@JsonPropertyOrder({
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_SIGNATURE,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_VERSION,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_NETWORK,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_TYPE,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_MAX_FEE,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_DEADLINE,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_MOSAIC_ID,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_RESTRICTION_KEY,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_PREVIOUS_RESTRICTION_VALUE,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_NEW_RESTRICTION_VALUE,
  MosaicAddressRestrictionTransactionDTO.JSON_PROPERTY_TARGET_ADDRESS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T21:07:49.823Z[UTC]")
public class MosaicAddressRestrictionTransactionDTO {
  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private String maxFee;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private String deadline;

  public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
  private String mosaicId;

  public static final String JSON_PROPERTY_RESTRICTION_KEY = "restrictionKey";
  private String restrictionKey;

  public static final String JSON_PROPERTY_PREVIOUS_RESTRICTION_VALUE = "previousRestrictionValue";
  private String previousRestrictionValue;

  public static final String JSON_PROPERTY_NEW_RESTRICTION_VALUE = "newRestrictionValue";
  private String newRestrictionValue;

  public static final String JSON_PROPERTY_TARGET_ADDRESS = "targetAddress";
  private String targetAddress;


  public MosaicAddressRestrictionTransactionDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public MosaicAddressRestrictionTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public MosaicAddressRestrictionTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public MosaicAddressRestrictionTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public MosaicAddressRestrictionTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public MosaicAddressRestrictionTransactionDTO maxFee(String maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(String maxFee) {
    this.maxFee = maxFee;
  }


  public MosaicAddressRestrictionTransactionDTO deadline(String deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDeadline() {
    return deadline;
  }


  public void setDeadline(String deadline) {
    this.deadline = deadline;
  }


  public MosaicAddressRestrictionTransactionDTO mosaicId(String mosaicId) {
    
    this.mosaicId = mosaicId;
    return this;
  }

   /**
   * Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. 
   * @return mosaicId
  **/
  @ApiModelProperty(example = "85BBEA6CC462B244", required = true, value = "Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
  @JsonProperty(JSON_PROPERTY_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMosaicId() {
    return mosaicId;
  }


  public void setMosaicId(String mosaicId) {
    this.mosaicId = mosaicId;
  }


  public MosaicAddressRestrictionTransactionDTO restrictionKey(String restrictionKey) {
    
    this.restrictionKey = restrictionKey;
    return this;
  }

   /**
   * Restriction key.
   * @return restrictionKey
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Restriction key.")
  @JsonProperty(JSON_PROPERTY_RESTRICTION_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRestrictionKey() {
    return restrictionKey;
  }


  public void setRestrictionKey(String restrictionKey) {
    this.restrictionKey = restrictionKey;
  }


  public MosaicAddressRestrictionTransactionDTO previousRestrictionValue(String previousRestrictionValue) {
    
    this.previousRestrictionValue = previousRestrictionValue;
    return this;
  }

   /**
   * Restriction value.
   * @return previousRestrictionValue
  **/
  @ApiModelProperty(example = "1000", required = true, value = "Restriction value.")
  @JsonProperty(JSON_PROPERTY_PREVIOUS_RESTRICTION_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPreviousRestrictionValue() {
    return previousRestrictionValue;
  }


  public void setPreviousRestrictionValue(String previousRestrictionValue) {
    this.previousRestrictionValue = previousRestrictionValue;
  }


  public MosaicAddressRestrictionTransactionDTO newRestrictionValue(String newRestrictionValue) {
    
    this.newRestrictionValue = newRestrictionValue;
    return this;
  }

   /**
   * Restriction value.
   * @return newRestrictionValue
  **/
  @ApiModelProperty(example = "1000", required = true, value = "Restriction value.")
  @JsonProperty(JSON_PROPERTY_NEW_RESTRICTION_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNewRestrictionValue() {
    return newRestrictionValue;
  }


  public void setNewRestrictionValue(String newRestrictionValue) {
    this.newRestrictionValue = newRestrictionValue;
  }


  public MosaicAddressRestrictionTransactionDTO targetAddress(String targetAddress) {
    
    this.targetAddress = targetAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. 
   * @return targetAddress
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required = true, value = "Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
  @JsonProperty(JSON_PROPERTY_TARGET_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetAddress() {
    return targetAddress;
  }


  public void setTargetAddress(String targetAddress) {
    this.targetAddress = targetAddress;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MosaicAddressRestrictionTransactionDTO mosaicAddressRestrictionTransactionDTO = (MosaicAddressRestrictionTransactionDTO) o;
    return Objects.equals(this.signature, mosaicAddressRestrictionTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, mosaicAddressRestrictionTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, mosaicAddressRestrictionTransactionDTO.version) &&
        Objects.equals(this.network, mosaicAddressRestrictionTransactionDTO.network) &&
        Objects.equals(this.type, mosaicAddressRestrictionTransactionDTO.type) &&
        Objects.equals(this.maxFee, mosaicAddressRestrictionTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, mosaicAddressRestrictionTransactionDTO.deadline) &&
        Objects.equals(this.mosaicId, mosaicAddressRestrictionTransactionDTO.mosaicId) &&
        Objects.equals(this.restrictionKey, mosaicAddressRestrictionTransactionDTO.restrictionKey) &&
        Objects.equals(this.previousRestrictionValue, mosaicAddressRestrictionTransactionDTO.previousRestrictionValue) &&
        Objects.equals(this.newRestrictionValue, mosaicAddressRestrictionTransactionDTO.newRestrictionValue) &&
        Objects.equals(this.targetAddress, mosaicAddressRestrictionTransactionDTO.targetAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signature, signerPublicKey, version, network, type, maxFee, deadline, mosaicId, restrictionKey, previousRestrictionValue, newRestrictionValue, targetAddress);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MosaicAddressRestrictionTransactionDTO {\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    mosaicId: ").append(toIndentedString(mosaicId)).append("\n");
    sb.append("    restrictionKey: ").append(toIndentedString(restrictionKey)).append("\n");
    sb.append("    previousRestrictionValue: ").append(toIndentedString(previousRestrictionValue)).append("\n");
    sb.append("    newRestrictionValue: ").append(toIndentedString(newRestrictionValue)).append("\n");
    sb.append("    targetAddress: ").append(toIndentedString(targetAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

