package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsNamesDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceIds;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespaceNameDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NamespacesInfoDTO;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T21:07:49.823Z[UTC]")
public class NamespaceRoutesApiImpl implements NamespaceRoutesApi {

    private ApiClient apiClient;

    public NamespaceRoutesApiImpl() {
        this(null);
    }

    public NamespaceRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get readable names for a set of accountIds
     * Returns friendly names for accounts.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountsNames(AccountIds accountIds, Handler<AsyncResult<AccountsNamesDTO>> resultHandler) {
        Object localVarBody = accountIds;
        
        // create path and map variables
        String localVarPath = "/account/names";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AccountsNamesDTO> localVarReturnType = new TypeReference<AccountsNamesDTO>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get readable names for a set of mosaics
     * Returns friendly names for mosaics.
     * @param mosaicIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicsNames(MosaicIds mosaicIds, Handler<AsyncResult<MosaicsNamesDTO>> resultHandler) {
        Object localVarBody = mosaicIds;
        
        // verify the required parameter 'mosaicIds' is set
        if (mosaicIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicIds' when calling getMosaicsNames"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/mosaic/names";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MosaicsNamesDTO> localVarReturnType = new TypeReference<MosaicsNamesDTO>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get namespace information
     * Gets the namespace for a given namespace identifier.
     * @param namespaceId Namespace identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespace(String namespaceId, Handler<AsyncResult<NamespaceInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'namespaceId' is set
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespace"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/namespace/{namespaceId}".replaceAll("\\{" + "namespaceId" + "\\}", namespaceId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NamespaceInfoDTO> localVarReturnType = new TypeReference<NamespaceInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get namespaces created by an account
     * Gets an array of namespaces for a given account address.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Namespace identifier up to which transactions are returned. (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespacesFromAccount(String accountId, Integer pageSize, String id, Handler<AsyncResult<NamespacesInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getNamespacesFromAccount"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}/namespaces".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "id", id));

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NamespacesInfoDTO> localVarReturnType = new TypeReference<NamespacesInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get namespaces for given array of addresses
     * Gets namespaces for a given array of addresses.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespacesFromAccounts(AccountIds accountIds, Handler<AsyncResult<NamespacesInfoDTO>> resultHandler) {
        Object localVarBody = accountIds;
        
        // create path and map variables
        String localVarPath = "/account/namespaces";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<NamespacesInfoDTO> localVarReturnType = new TypeReference<NamespacesInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get readable names for a set of namespaces
     * Returns friendly names for namespaces.
     * @param namespaceIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getNamespacesNames(NamespaceIds namespaceIds, Handler<AsyncResult<List<NamespaceNameDTO>>> resultHandler) {
        Object localVarBody = namespaceIds;
        
        // verify the required parameter 'namespaceIds' is set
        if (namespaceIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceIds' when calling getNamespacesNames"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/namespace/names";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<NamespaceNameDTO>> localVarReturnType = new TypeReference<List<NamespaceNameDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
