/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "supply", "startHeight", "ownerPublicKey", "ownerAddress", "revision", "flags", "divisibility", "duration"})
public class MosaicDTO {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_SUPPLY = "supply";
    private BigInteger supply = null;
    public static final String JSON_PROPERTY_START_HEIGHT = "startHeight";
    private BigInteger startHeight = null;
    public static final String JSON_PROPERTY_OWNER_PUBLIC_KEY = "ownerPublicKey";
    private String ownerPublicKey;
    public static final String JSON_PROPERTY_OWNER_ADDRESS = "ownerAddress";
    private String ownerAddress;
    public static final String JSON_PROPERTY_REVISION = "revision";
    private Integer revision;
    public static final String JSON_PROPERTY_FLAGS = "flags";
    private Integer flags;
    public static final String JSON_PROPERTY_DIVISIBILITY = "divisibility";
    private Integer divisibility;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private BigInteger duration = null;

    public MosaicDTO id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MosaicDTO supply(BigInteger supply) {
        this.supply = supply;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="supply")
    public BigInteger getSupply() {
        return this.supply;
    }

    public void setSupply(BigInteger supply) {
        this.supply = supply;
    }

    public MosaicDTO startHeight(BigInteger startHeight) {
        this.startHeight = startHeight;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    @JsonProperty(value="startHeight")
    public BigInteger getStartHeight() {
        return this.startHeight;
    }

    public void setStartHeight(BigInteger startHeight) {
        this.startHeight = startHeight;
    }

    public MosaicDTO ownerPublicKey(String ownerPublicKey) {
        this.ownerPublicKey = ownerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="ownerPublicKey")
    public String getOwnerPublicKey() {
        return this.ownerPublicKey;
    }

    public void setOwnerPublicKey(String ownerPublicKey) {
        this.ownerPublicKey = ownerPublicKey;
    }

    public MosaicDTO ownerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
        return this;
    }

    @ApiModelProperty(example="9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required=true, value="Address expressed in hexadecimal base.")
    @JsonProperty(value="ownerAddress")
    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public MosaicDTO revision(Integer revision) {
        this.revision = revision;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Number of definitions for the same mosaic.")
    @JsonProperty(value="revision")
    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public MosaicDTO flags(Integer flags) {
        this.flags = flags;
        return this;
    }

    @ApiModelProperty(required=true, value="- 0x00 (none) - No flags present. - 0x01 (supplyMutable) - Mosaic supports supply changes even when mosaic owner owns partial supply. - 0x02 (transferable) - Mosaic supports transfers between arbitrary accounts. When not set, mosaic can only be transferred to and from mosaic owner. - 0x04 (restrictable) - Mosaic supports custom restrictions configured by mosaic owner. ")
    @JsonProperty(value="flags")
    public Integer getFlags() {
        return this.flags;
    }

    public void setFlags(Integer flags) {
        this.flags = flags;
    }

    public MosaicDTO divisibility(Integer divisibility) {
        this.divisibility = divisibility;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines up to what decimal place the mosaic can be divided. Divisibility of 3 means that a mosaic can be divided into smallest parts of 0.001 mosaics. The divisibility must be in the range of 0 and 6. ")
    @JsonProperty(value="divisibility")
    public Integer getDivisibility() {
        return this.divisibility;
    }

    public void setDivisibility(Integer divisibility) {
        this.divisibility = divisibility;
    }

    public MosaicDTO duration(BigInteger duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    @JsonProperty(value="duration")
    public BigInteger getDuration() {
        return this.duration;
    }

    public void setDuration(BigInteger duration) {
        this.duration = duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicDTO mosaicDTO = (MosaicDTO)o;
        return Objects.equals(this.id, mosaicDTO.id) && Objects.equals(this.supply, mosaicDTO.supply) && Objects.equals(this.startHeight, mosaicDTO.startHeight) && Objects.equals(this.ownerPublicKey, mosaicDTO.ownerPublicKey) && Objects.equals(this.ownerAddress, mosaicDTO.ownerAddress) && Objects.equals(this.revision, mosaicDTO.revision) && Objects.equals(this.flags, mosaicDTO.flags) && Objects.equals(this.divisibility, mosaicDTO.divisibility) && Objects.equals(this.duration, mosaicDTO.duration);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.supply, this.startHeight, this.ownerPublicKey, this.ownerAddress, this.revision, this.flags, this.divisibility, this.duration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    supply: ").append(this.toIndentedString(this.supply)).append("\n");
        sb.append("    startHeight: ").append(this.toIndentedString(this.startHeight)).append("\n");
        sb.append("    ownerPublicKey: ").append(this.toIndentedString(this.ownerPublicKey)).append("\n");
        sb.append("    ownerAddress: ").append(this.toIndentedString(this.ownerAddress)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    divisibility: ").append(this.toIndentedString(this.divisibility)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

