/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.22
 *
 * The version of the OpenAPI document: 0.8.7
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicMetadataTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Transaction to create or modify a multisig account.
 */
@ApiModel(description = "Transaction to create or modify a multisig account.")
@JsonPropertyOrder({
  MosaicMetadataTransactionDTO.JSON_PROPERTY_SIGNATURE,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_VERSION,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_NETWORK,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_TYPE,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_MAX_FEE,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_DEADLINE,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_TARGET_PUBLIC_KEY,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_SCOPED_METADATA_KEY,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_TARGET_MOSAIC_ID,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_VALUE_SIZE_DELTA,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_VALUE_SIZE,
  MosaicMetadataTransactionDTO.JSON_PROPERTY_VALUE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T19:40:23.988-03:00[America/Argentina/Buenos_Aires]")
public class MosaicMetadataTransactionDTO {
  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private java.math.BigInteger maxFee = null;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private java.math.BigInteger deadline = null;

  public static final String JSON_PROPERTY_TARGET_PUBLIC_KEY = "targetPublicKey";
  private String targetPublicKey;

  public static final String JSON_PROPERTY_SCOPED_METADATA_KEY = "scopedMetadataKey";
  private String scopedMetadataKey;

  public static final String JSON_PROPERTY_TARGET_MOSAIC_ID = "targetMosaicId";
  private String targetMosaicId;

  public static final String JSON_PROPERTY_VALUE_SIZE_DELTA = "valueSizeDelta";
  private Integer valueSizeDelta;

  public static final String JSON_PROPERTY_VALUE_SIZE = "valueSize";
  private Integer valueSize;

  public static final String JSON_PROPERTY_VALUE = "value";
  private String value;


  public MosaicMetadataTransactionDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public MosaicMetadataTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public MosaicMetadataTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public MosaicMetadataTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public MosaicMetadataTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public MosaicMetadataTransactionDTO maxFee(java.math.BigInteger maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(java.math.BigInteger maxFee) {
    this.maxFee = maxFee;
  }


  public MosaicMetadataTransactionDTO deadline(java.math.BigInteger deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDeadline() {
    return deadline;
  }


  public void setDeadline(java.math.BigInteger deadline) {
    this.deadline = deadline;
  }


  public MosaicMetadataTransactionDTO targetPublicKey(String targetPublicKey) {
    
    this.targetPublicKey = targetPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return targetPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_TARGET_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetPublicKey() {
    return targetPublicKey;
  }


  public void setTargetPublicKey(String targetPublicKey) {
    this.targetPublicKey = targetPublicKey;
  }


  public MosaicMetadataTransactionDTO scopedMetadataKey(String scopedMetadataKey) {
    
    this.scopedMetadataKey = scopedMetadataKey;
    return this;
  }

   /**
   * Metadata key scoped to source, target and type expressed.
   * @return scopedMetadataKey
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Metadata key scoped to source, target and type expressed.")
  @JsonProperty(JSON_PROPERTY_SCOPED_METADATA_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getScopedMetadataKey() {
    return scopedMetadataKey;
  }


  public void setScopedMetadataKey(String scopedMetadataKey) {
    this.scopedMetadataKey = scopedMetadataKey;
  }


  public MosaicMetadataTransactionDTO targetMosaicId(String targetMosaicId) {
    
    this.targetMosaicId = targetMosaicId;
    return this;
  }

   /**
   * Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. 
   * @return targetMosaicId
  **/
  @ApiModelProperty(example = "85BBEA6CC462B244", required = true, value = "Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
  @JsonProperty(JSON_PROPERTY_TARGET_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTargetMosaicId() {
    return targetMosaicId;
  }


  public void setTargetMosaicId(String targetMosaicId) {
    this.targetMosaicId = targetMosaicId;
  }


  public MosaicMetadataTransactionDTO valueSizeDelta(Integer valueSizeDelta) {
    
    this.valueSizeDelta = valueSizeDelta;
    return this;
  }

   /**
   * Change in value size in bytes.
   * @return valueSizeDelta
  **/
  @ApiModelProperty(required = true, value = "Change in value size in bytes.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE_DELTA)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getValueSizeDelta() {
    return valueSizeDelta;
  }


  public void setValueSizeDelta(Integer valueSizeDelta) {
    this.valueSizeDelta = valueSizeDelta;
  }


  public MosaicMetadataTransactionDTO valueSize(Integer valueSize) {
    
    this.valueSize = valueSize;
    return this;
  }

   /**
   * Value size in bytes.
   * @return valueSize
  **/
  @ApiModelProperty(required = true, value = "Value size in bytes.")
  @JsonProperty(JSON_PROPERTY_VALUE_SIZE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getValueSize() {
    return valueSize;
  }


  public void setValueSize(Integer valueSize) {
    this.valueSize = valueSize;
  }


  public MosaicMetadataTransactionDTO value(String value) {
    
    this.value = value;
    return this;
  }

   /**
   * Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).
   * @return value
  **/
  @ApiModelProperty(required = true, value = "Metadata value. If embedded in a transaction, this is calculated as xor(previous-value, value).")
  @JsonProperty(JSON_PROPERTY_VALUE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getValue() {
    return value;
  }


  public void setValue(String value) {
    this.value = value;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MosaicMetadataTransactionDTO mosaicMetadataTransactionDTO = (MosaicMetadataTransactionDTO) o;
    return Objects.equals(this.signature, mosaicMetadataTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, mosaicMetadataTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, mosaicMetadataTransactionDTO.version) &&
        Objects.equals(this.network, mosaicMetadataTransactionDTO.network) &&
        Objects.equals(this.type, mosaicMetadataTransactionDTO.type) &&
        Objects.equals(this.maxFee, mosaicMetadataTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, mosaicMetadataTransactionDTO.deadline) &&
        Objects.equals(this.targetPublicKey, mosaicMetadataTransactionDTO.targetPublicKey) &&
        Objects.equals(this.scopedMetadataKey, mosaicMetadataTransactionDTO.scopedMetadataKey) &&
        Objects.equals(this.targetMosaicId, mosaicMetadataTransactionDTO.targetMosaicId) &&
        Objects.equals(this.valueSizeDelta, mosaicMetadataTransactionDTO.valueSizeDelta) &&
        Objects.equals(this.valueSize, mosaicMetadataTransactionDTO.valueSize) &&
        Objects.equals(this.value, mosaicMetadataTransactionDTO.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signature, signerPublicKey, version, network, type, maxFee, deadline, targetPublicKey, scopedMetadataKey, targetMosaicId, valueSizeDelta, valueSize, value);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MosaicMetadataTransactionDTO {\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    targetPublicKey: ").append(toIndentedString(targetPublicKey)).append("\n");
    sb.append("    scopedMetadataKey: ").append(toIndentedString(scopedMetadataKey)).append("\n");
    sb.append("    targetMosaicId: ").append(toIndentedString(targetMosaicId)).append("\n");
    sb.append("    valueSizeDelta: ").append(toIndentedString(valueSizeDelta)).append("\n");
    sb.append("    valueSize: ").append(toIndentedString(valueSize)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

