package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.StatementsDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T19:40:23.988-03:00[America/Argentina/Buenos_Aires]")
public class ReceiptRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi delegate;

	public ReceiptRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get receipts from a block
     * Returns the receipts linked to a block.
     * @param height Block height.  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getBlockReceipts(java.math.BigInteger height, Handler<AsyncResult<StatementsDTO>> resultHandler) {
        delegate.getBlockReceipts(height, resultHandler);
    }

    /**
     * Get receipts from a block
     * Returns the receipts linked to a block.
     * @param height Block height.  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<StatementsDTO> rxGetBlockReceipts(java.math.BigInteger height) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getBlockReceipts(height, fut);
        }));
    }
    /**
     * Get the merkle path for a given a receipt statement hash and block
     * Returns the merkle path for a receipt statement or resolution linked to a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.receiptsHash) to verify if the statement was linked with the block. 
     * @param height Block height.  (required)
     * @param hash Receipt hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMerkleReceipts(java.math.BigInteger height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> resultHandler) {
        delegate.getMerkleReceipts(height, hash, resultHandler);
    }

    /**
     * Get the merkle path for a given a receipt statement hash and block
     * Returns the merkle path for a receipt statement or resolution linked to a block. The merkle path is the minimum number of nodes needed to calculate the merkle root.  Steps to calculate the merkle root: 1. proofHash &#x3D; hash (leaf). 2. Concatenate proofHash with the first unprocessed item from the merklePath list as follows: * a) If item.position &#x3D;&#x3D; left -&gt; proofHash &#x3D; sha_256(item.hash + proofHash). * b) If item.position &#x3D;&#x3D; right -&gt; proofHash &#x3D; sha_256(proofHash+ item.hash). 3. Repeat 2. for every item in the merklePath list. 4. Compare if the calculated proofHash equals the one recorded in the block header (block.receiptsHash) to verify if the statement was linked with the block. 
     * @param height Block height.  (required)
     * @param hash Receipt hash. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MerkleProofInfoDTO> rxGetMerkleReceipts(java.math.BigInteger height, String hash) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMerkleReceipts(height, hash, fut);
        }));
    }

    public static ReceiptRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.ReceiptRoutesApi arg) {
        return arg != null ? new ReceiptRoutesApi(arg) : null;
    }
}
