package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AnnounceTransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.Cosignature;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionHashes;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionIds;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionPayload;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionStatusDTO;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T19:40:23.988-03:00[America/Argentina/Buenos_Aires]")
public class TransactionRoutesApiImpl implements TransactionRoutesApi {

    private ApiClient apiClient;

    public TransactionRoutesApiImpl() {
        this(null);
    }

    public TransactionRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Announce a cosignature transaction
     * Announces a cosignature transaction to the network.
     * @param cosignature  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announceCosignatureTransaction(Cosignature cosignature, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        Object localVarBody = cosignature;
        
        // verify the required parameter 'cosignature' is set
        if (cosignature == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'cosignature' when calling announceCosignatureTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transaction/cosignature";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AnnounceTransactionInfoDTO> localVarReturnType = new TypeReference<AnnounceTransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Announce an aggregate bonded transaction
     * Announces an aggregate bonded transaction to the network.
     * @param transactionPayload  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announcePartialTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        Object localVarBody = transactionPayload;
        
        // verify the required parameter 'transactionPayload' is set
        if (transactionPayload == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionPayload' when calling announcePartialTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transaction/partial";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AnnounceTransactionInfoDTO> localVarReturnType = new TypeReference<AnnounceTransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Announce a new transaction
     * Announces a transaction to the network. We recommended to use the Symbol-SDKs to announce transactions because they should be serialized. 
     * @param transactionPayload  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void announceTransaction(TransactionPayload transactionPayload, Handler<AsyncResult<AnnounceTransactionInfoDTO>> resultHandler) {
        Object localVarBody = transactionPayload;
        
        // verify the required parameter 'transactionPayload' is set
        if (transactionPayload == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionPayload' when calling announceTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transaction";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<AnnounceTransactionInfoDTO> localVarReturnType = new TypeReference<AnnounceTransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get transaction information
     * Returns transaction information given a transactionId or hash.
     * @param transactionId Transaction identifier or hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransaction(String transactionId, Handler<AsyncResult<TransactionInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'transactionId' is set
        if (transactionId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionId' when calling getTransaction"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transaction/{transactionId}".replaceAll("\\{" + "transactionId" + "\\}", transactionId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<TransactionInfoDTO> localVarReturnType = new TypeReference<TransactionInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get transaction status
     * Returns the transaction status for a given hash.
     * @param hash Transaction hash. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransactionStatus(String hash, Handler<AsyncResult<TransactionStatusDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'hash' is set
        if (hash == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'hash' when calling getTransactionStatus"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transaction/{hash}/status".replaceAll("\\{" + "hash" + "\\}", hash.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<TransactionStatusDTO> localVarReturnType = new TypeReference<TransactionStatusDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get transactions information
     * Returns transactions information for a given array of transactionIds.
     * @param transactionIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransactions(TransactionIds transactionIds, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        Object localVarBody = transactionIds;
        
        // verify the required parameter 'transactionIds' is set
        if (transactionIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionIds' when calling getTransactions"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transaction";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionInfoDTO>> localVarReturnType = new TypeReference<List<TransactionInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get transactions status
     * Returns an array of transaction statuses for a given array of transaction hashes.
     * @param transactionHashes  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getTransactionsStatuses(TransactionHashes transactionHashes, Handler<AsyncResult<List<TransactionStatusDTO>>> resultHandler) {
        Object localVarBody = transactionHashes;
        
        // verify the required parameter 'transactionHashes' is set
        if (transactionHashes == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'transactionHashes' when calling getTransactionsStatuses"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/transaction/statuses";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // cookie params
        MultiMap localVarCookieParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<TransactionStatusDTO>> localVarReturnType = new TypeReference<List<TransactionStatusDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
