/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.22
 *
 * The version of the OpenAPI document: 0.8.7
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.AccountLinkActionEnum;
import io.nem.symbol.sdk.openapi.vertx.model.AccountLinkTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Delegates the account importance score to a proxy account.
 */
@ApiModel(description = "Delegates the account importance score to a proxy account.")
@JsonPropertyOrder({
  AccountLinkTransactionDTO.JSON_PROPERTY_SIGNATURE,
  AccountLinkTransactionDTO.JSON_PROPERTY_SIGNER_PUBLIC_KEY,
  AccountLinkTransactionDTO.JSON_PROPERTY_VERSION,
  AccountLinkTransactionDTO.JSON_PROPERTY_NETWORK,
  AccountLinkTransactionDTO.JSON_PROPERTY_TYPE,
  AccountLinkTransactionDTO.JSON_PROPERTY_MAX_FEE,
  AccountLinkTransactionDTO.JSON_PROPERTY_DEADLINE,
  AccountLinkTransactionDTO.JSON_PROPERTY_REMOTE_PUBLIC_KEY,
  AccountLinkTransactionDTO.JSON_PROPERTY_LINK_ACTION
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T21:45:14.408Z[UTC]")
public class AccountLinkTransactionDTO {
  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  private String maxFee;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  private String deadline;

  public static final String JSON_PROPERTY_REMOTE_PUBLIC_KEY = "remotePublicKey";
  private String remotePublicKey;

  public static final String JSON_PROPERTY_LINK_ACTION = "linkAction";
  private AccountLinkActionEnum linkAction;


  public AccountLinkTransactionDTO signature(String signature) {
    
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignature() {
    return signature;
  }


  public void setSignature(String signature) {
    this.signature = signature;
  }


  public AccountLinkTransactionDTO signerPublicKey(String signerPublicKey) {
    
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSignerPublicKey() {
    return signerPublicKey;
  }


  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }


  public AccountLinkTransactionDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public AccountLinkTransactionDTO network(NetworkTypeEnum network) {
    
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_NETWORK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public NetworkTypeEnum getNetwork() {
    return network;
  }


  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }


  public AccountLinkTransactionDTO type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public AccountLinkTransactionDTO maxFee(String maxFee) {
    
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMaxFee() {
    return maxFee;
  }


  public void setMaxFee(String maxFee) {
    this.maxFee = maxFee;
  }


  public AccountLinkTransactionDTO deadline(String deadline) {
    
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDeadline() {
    return deadline;
  }


  public void setDeadline(String deadline) {
    this.deadline = deadline;
  }


  public AccountLinkTransactionDTO remotePublicKey(String remotePublicKey) {
    
    this.remotePublicKey = remotePublicKey;
    return this;
  }

   /**
   * Public key.
   * @return remotePublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  @JsonProperty(JSON_PROPERTY_REMOTE_PUBLIC_KEY)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRemotePublicKey() {
    return remotePublicKey;
  }


  public void setRemotePublicKey(String remotePublicKey) {
    this.remotePublicKey = remotePublicKey;
  }


  public AccountLinkTransactionDTO linkAction(AccountLinkActionEnum linkAction) {
    
    this.linkAction = linkAction;
    return this;
  }

   /**
   * Get linkAction
   * @return linkAction
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_LINK_ACTION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AccountLinkActionEnum getLinkAction() {
    return linkAction;
  }


  public void setLinkAction(AccountLinkActionEnum linkAction) {
    this.linkAction = linkAction;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountLinkTransactionDTO accountLinkTransactionDTO = (AccountLinkTransactionDTO) o;
    return Objects.equals(this.signature, accountLinkTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, accountLinkTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, accountLinkTransactionDTO.version) &&
        Objects.equals(this.network, accountLinkTransactionDTO.network) &&
        Objects.equals(this.type, accountLinkTransactionDTO.type) &&
        Objects.equals(this.maxFee, accountLinkTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, accountLinkTransactionDTO.deadline) &&
        Objects.equals(this.remotePublicKey, accountLinkTransactionDTO.remotePublicKey) &&
        Objects.equals(this.linkAction, accountLinkTransactionDTO.linkAction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signature, signerPublicKey, version, network, type, maxFee, deadline, remotePublicKey, linkAction);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountLinkTransactionDTO {\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    remotePublicKey: ").append(toIndentedString(remotePublicKey)).append("\n");
    sb.append("    linkAction: ").append(toIndentedString(linkAction)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

