package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.NodeHealthInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NodeInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.NodeTimeDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ServerInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.StorageInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T21:45:14.408Z[UTC]")
public class NodeRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApi delegate;

	public NodeRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get the node health information
     * Supplies information regarding the connection and services status.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeHealth(Handler<AsyncResult<NodeHealthInfoDTO>> resultHandler) {
        delegate.getNodeHealth(resultHandler);
    }

    /**
     * Get the node health information
     * Supplies information regarding the connection and services status.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NodeHealthInfoDTO> rxGetNodeHealth() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNodeHealth(fut);
        }));
    }
    /**
     * Get the node information
     * Supplies additional information about the application running on a node.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeInfo(Handler<AsyncResult<NodeInfoDTO>> resultHandler) {
        delegate.getNodeInfo(resultHandler);
    }

    /**
     * Get the node information
     * Supplies additional information about the application running on a node.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NodeInfoDTO> rxGetNodeInfo() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNodeInfo(fut);
        }));
    }
    /**
     * Get peers information
     * Gets the list of peers visible by the node.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodePeers(Handler<AsyncResult<List<NodeInfoDTO>>> resultHandler) {
        delegate.getNodePeers(resultHandler);
    }

    /**
     * Get peers information
     * Gets the list of peers visible by the node.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<NodeInfoDTO>> rxGetNodePeers() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNodePeers(fut);
        }));
    }
    /**
     * Get the storage information of the node
     * Returns storage information about the node.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeStorage(Handler<AsyncResult<StorageInfoDTO>> resultHandler) {
        delegate.getNodeStorage(resultHandler);
    }

    /**
     * Get the storage information of the node
     * Returns storage information about the node.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<StorageInfoDTO> rxGetNodeStorage() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNodeStorage(fut);
        }));
    }
    /**
     * Get the node time
     * Gets the node time at the moment the reply was sent and received.
     * @param resultHandler Asynchronous result handler
     */
    public void getNodeTime(Handler<AsyncResult<NodeTimeDTO>> resultHandler) {
        delegate.getNodeTime(resultHandler);
    }

    /**
     * Get the node time
     * Gets the node time at the moment the reply was sent and received.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<NodeTimeDTO> rxGetNodeTime() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getNodeTime(fut);
        }));
    }
    /**
     * Get the version of the running REST component
     * Returns the version of the running catapult-rest component.
     * @param resultHandler Asynchronous result handler
     */
    public void getServerInfo(Handler<AsyncResult<ServerInfoDTO>> resultHandler) {
        delegate.getServerInfo(resultHandler);
    }

    /**
     * Get the version of the running REST component
     * Returns the version of the running catapult-rest component.
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<ServerInfoDTO> rxGetServerInfo() {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getServerInfo(fut);
        }));
    }

    public static NodeRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.NodeRoutesApi arg) {
        return arg != null ? new NodeRoutesApi(arg) : null;
    }
}
