package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountGraphInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MultisigAccountInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T21:45:14.408Z[UTC]")
public class MultisigRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApi delegate;

	public MultisigRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get multisig account information
     * Returns the multisig account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisig(String accountId, Handler<AsyncResult<MultisigAccountInfoDTO>> resultHandler) {
        delegate.getAccountMultisig(accountId, resultHandler);
    }

    /**
     * Get multisig account information
     * Returns the multisig account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MultisigAccountInfoDTO> rxGetAccountMultisig(String accountId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMultisig(accountId, fut);
        }));
    }
    /**
     * Get multisig account graph information
     * Returns the multisig account graph.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountMultisigGraph(String accountId, Handler<AsyncResult<List<MultisigAccountGraphInfoDTO>>> resultHandler) {
        delegate.getAccountMultisigGraph(accountId, resultHandler);
    }

    /**
     * Get multisig account graph information
     * Returns the multisig account graph.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<MultisigAccountGraphInfoDTO>> rxGetAccountMultisigGraph(String accountId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountMultisigGraph(accountId, fut);
        }));
    }

    public static MultisigRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.MultisigRoutesApi arg) {
        return arg != null ? new MultisigRoutesApi(arg) : null;
    }
}
