package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionTypeEnum;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-11T21:45:14.408Z[UTC]")
public class AccountRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi delegate;

	public AccountRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get confirmed transactions
     * Gets an array of transactions for which an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountConfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getAccountConfirmedTransactions(accountId, pageSize, id, ordering, type, resultHandler);
    }

    /**
     * Get confirmed transactions
     * Gets an array of transactions for which an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetAccountConfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountConfirmedTransactions(accountId, pageSize, id, ordering, type, fut);
        }));
    }
    /**
     * Get incoming transactions
     * Gets an array of incoming transactions. A transaction is said to be incoming with respect to an account if the account is the recipient of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountIncomingTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getAccountIncomingTransactions(accountId, pageSize, id, ordering, type, resultHandler);
    }

    /**
     * Get incoming transactions
     * Gets an array of incoming transactions. A transaction is said to be incoming with respect to an account if the account is the recipient of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetAccountIncomingTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountIncomingTransactions(accountId, pageSize, id, ordering, type, fut);
        }));
    }
    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountInfo(String accountId, Handler<AsyncResult<AccountInfoDTO>> resultHandler) {
        delegate.getAccountInfo(accountId, resultHandler);
    }

    /**
     * Get account information
     * Returns the account information.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountInfoDTO> rxGetAccountInfo(String accountId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountInfo(accountId, fut);
        }));
    }
    /**
     * Get outgoing transactions
     * Gets an array of outgoing transactions. A transaction is said to be outgoing with respect to an account if the account is the sender of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountOutgoingTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getAccountOutgoingTransactions(accountId, pageSize, id, ordering, type, resultHandler);
    }

    /**
     * Get outgoing transactions
     * Gets an array of outgoing transactions. A transaction is said to be outgoing with respect to an account if the account is the sender of the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetAccountOutgoingTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountOutgoingTransactions(accountId, pageSize, id, ordering, type, fut);
        }));
    }
    /**
     * Get aggregate bonded transactions information
     * Gets an array of aggregate bonded transactions where the account is the sender or requires to cosign the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountPartialTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getAccountPartialTransactions(accountId, pageSize, id, ordering, type, resultHandler);
    }

    /**
     * Get aggregate bonded transactions information
     * Gets an array of aggregate bonded transactions where the account is the sender or requires to cosign the transaction. 
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetAccountPartialTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountPartialTransactions(accountId, pageSize, id, ordering, type, fut);
        }));
    }
    /**
     * Get unconfirmed transactions
     * Gets the array of transactions not included in a block where an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountUnconfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type, Handler<AsyncResult<List<TransactionInfoDTO>>> resultHandler) {
        delegate.getAccountUnconfirmedTransactions(accountId, pageSize, id, ordering, type, resultHandler);
    }

    /**
     * Get unconfirmed transactions
     * Gets the array of transactions not included in a block where an account is the sender or receiver.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param pageSize Number of transactions to return for each request. (optional, default to 10)
     * @param id Transaction identifier up to which transactions are returned. (optional)
     * @param ordering Ordering criteria: * -id - Descending order by id. * id - Ascending order by id.  (optional, default to &quot;-id&quot;)
     * @param type Transaction type to filter by. To filter by multiple transaction types, add more filter query params like: &#x60;&#x60;type&#x3D;16974&amp;type&#x3D;16718&#x60;&#x60;.  (optional, default to new ArrayList&lt;&gt;())
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<TransactionInfoDTO>> rxGetAccountUnconfirmedTransactions(String accountId, Integer pageSize, String id, String ordering, List<TransactionTypeEnum> type) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountUnconfirmedTransactions(accountId, pageSize, id, ordering, type, fut);
        }));
    }
    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountsInfo(AccountIds accountIds, Handler<AsyncResult<List<AccountInfoDTO>>> resultHandler) {
        delegate.getAccountsInfo(accountIds, resultHandler);
    }

    /**
     * Get accounts information
     * Returns the account information for an array of accounts.
     * @param accountIds  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<AccountInfoDTO>> rxGetAccountsInfo(AccountIds accountIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountsInfo(accountIds, fut);
        }));
    }

    public static AccountRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.AccountRoutesApi arg) {
        return arg != null ? new AccountRoutesApi(arg) : null;
    }
}
