package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.BlockInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleProofInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionInfoDTO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;

import java.util.*;

public interface BlockRoutesApi {

    void getBlockByHeight(String height, Handler<AsyncResult<BlockInfoDTO>> handler);

    void getBlockTransactions(String height, Integer pageSize, String id, String ordering, Handler<AsyncResult<List<TransactionInfoDTO>>> handler);

    void getBlocksByHeightWithLimit(String height, Integer limit, Handler<AsyncResult<List<BlockInfoDTO>>> handler);

    void getMerkleTransaction(String height, String hash, Handler<AsyncResult<MerkleProofInfoDTO>> handler);

}
