/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionFlagsEnum;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Transaction to prevent incoming transactions containing a given set of mosaics.")
@JsonPropertyOrder(value={"signature", "signerPublicKey", "version", "network", "type", "maxFee", "deadline", "restrictionFlags", "restrictionAdditions", "restrictionDeletions"})
public class AccountMosaicRestrictionTransactionDTO {
    public static final String JSON_PROPERTY_SIGNATURE = "signature";
    private String signature;
    public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
    private String signerPublicKey;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Integer version;
    public static final String JSON_PROPERTY_NETWORK = "network";
    private NetworkTypeEnum network;
    public static final String JSON_PROPERTY_TYPE = "type";
    private Integer type;
    public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
    private BigInteger maxFee = null;
    public static final String JSON_PROPERTY_DEADLINE = "deadline";
    private BigInteger deadline = null;
    public static final String JSON_PROPERTY_RESTRICTION_FLAGS = "restrictionFlags";
    private AccountRestrictionFlagsEnum restrictionFlags;
    public static final String JSON_PROPERTY_RESTRICTION_ADDITIONS = "restrictionAdditions";
    private List<String> restrictionAdditions = new ArrayList<String>();
    public static final String JSON_PROPERTY_RESTRICTION_DELETIONS = "restrictionDeletions";
    private List<String> restrictionDeletions = new ArrayList<String>();

    public AccountMosaicRestrictionTransactionDTO signature(String signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required=true, value="Entity's signature generated by the signer.")
    @JsonProperty(value="signature")
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public AccountMosaicRestrictionTransactionDTO signerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
        return this;
    }

    @ApiModelProperty(example="AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required=true, value="Public key.")
    @JsonProperty(value="signerPublicKey")
    public String getSignerPublicKey() {
        return this.signerPublicKey;
    }

    public void setSignerPublicKey(String signerPublicKey) {
        this.signerPublicKey = signerPublicKey;
    }

    public AccountMosaicRestrictionTransactionDTO version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="Entity version.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AccountMosaicRestrictionTransactionDTO network(NetworkTypeEnum network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="network")
    public NetworkTypeEnum getNetwork() {
        return this.network;
    }

    public void setNetwork(NetworkTypeEnum network) {
        this.network = network;
    }

    public AccountMosaicRestrictionTransactionDTO type(Integer type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public AccountMosaicRestrictionTransactionDTO maxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
        return this;
    }

    @ApiModelProperty(example="123456", required=true, value="Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
    @JsonProperty(value="maxFee")
    public BigInteger getMaxFee() {
        return this.maxFee;
    }

    public void setMaxFee(BigInteger maxFee) {
        this.maxFee = maxFee;
    }

    public AccountMosaicRestrictionTransactionDTO deadline(BigInteger deadline) {
        this.deadline = deadline;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    @JsonProperty(value="deadline")
    public BigInteger getDeadline() {
        return this.deadline;
    }

    public void setDeadline(BigInteger deadline) {
        this.deadline = deadline;
    }

    public AccountMosaicRestrictionTransactionDTO restrictionFlags(AccountRestrictionFlagsEnum restrictionFlags) {
        this.restrictionFlags = restrictionFlags;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="restrictionFlags")
    public AccountRestrictionFlagsEnum getRestrictionFlags() {
        return this.restrictionFlags;
    }

    public void setRestrictionFlags(AccountRestrictionFlagsEnum restrictionFlags) {
        this.restrictionFlags = restrictionFlags;
    }

    public AccountMosaicRestrictionTransactionDTO restrictionAdditions(List<String> restrictionAdditions) {
        this.restrictionAdditions = restrictionAdditions;
        return this;
    }

    public AccountMosaicRestrictionTransactionDTO addRestrictionAdditionsItem(String restrictionAdditionsItem) {
        this.restrictionAdditions.add(restrictionAdditionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Account restriction additions.")
    @JsonProperty(value="restrictionAdditions")
    public List<String> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public void setRestrictionAdditions(List<String> restrictionAdditions) {
        this.restrictionAdditions = restrictionAdditions;
    }

    public AccountMosaicRestrictionTransactionDTO restrictionDeletions(List<String> restrictionDeletions) {
        this.restrictionDeletions = restrictionDeletions;
        return this;
    }

    public AccountMosaicRestrictionTransactionDTO addRestrictionDeletionsItem(String restrictionDeletionsItem) {
        this.restrictionDeletions.add(restrictionDeletionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Account restriction deletions.")
    @JsonProperty(value="restrictionDeletions")
    public List<String> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }

    public void setRestrictionDeletions(List<String> restrictionDeletions) {
        this.restrictionDeletions = restrictionDeletions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountMosaicRestrictionTransactionDTO accountMosaicRestrictionTransactionDTO = (AccountMosaicRestrictionTransactionDTO)o;
        return Objects.equals(this.signature, accountMosaicRestrictionTransactionDTO.signature) && Objects.equals(this.signerPublicKey, accountMosaicRestrictionTransactionDTO.signerPublicKey) && Objects.equals(this.version, accountMosaicRestrictionTransactionDTO.version) && Objects.equals((Object)this.network, (Object)accountMosaicRestrictionTransactionDTO.network) && Objects.equals(this.type, accountMosaicRestrictionTransactionDTO.type) && Objects.equals(this.maxFee, accountMosaicRestrictionTransactionDTO.maxFee) && Objects.equals(this.deadline, accountMosaicRestrictionTransactionDTO.deadline) && Objects.equals((Object)this.restrictionFlags, (Object)accountMosaicRestrictionTransactionDTO.restrictionFlags) && Objects.equals(this.restrictionAdditions, accountMosaicRestrictionTransactionDTO.restrictionAdditions) && Objects.equals(this.restrictionDeletions, accountMosaicRestrictionTransactionDTO.restrictionDeletions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signature, this.signerPublicKey, this.version, this.network, this.type, this.maxFee, this.deadline, this.restrictionFlags, this.restrictionAdditions, this.restrictionDeletions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountMosaicRestrictionTransactionDTO {\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    signerPublicKey: ").append(this.toIndentedString(this.signerPublicKey)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    maxFee: ").append(this.toIndentedString(this.maxFee)).append("\n");
        sb.append("    deadline: ").append(this.toIndentedString(this.deadline)).append("\n");
        sb.append("    restrictionFlags: ").append(this.toIndentedString((Object)this.restrictionFlags)).append("\n");
        sb.append("    restrictionAdditions: ").append(this.toIndentedString(this.restrictionAdditions)).append("\n");
        sb.append("    restrictionDeletions: ").append(this.toIndentedString(this.restrictionDeletions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

