/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.20
 *
 * The version of the OpenAPI document: 0.8.6
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.LockHashAlgorithmEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * SecretLockTransactionBodyDTO
 */
@JsonPropertyOrder({
  SecretLockTransactionBodyDTO.JSON_PROPERTY_SECRET,
  SecretLockTransactionBodyDTO.JSON_PROPERTY_MOSAIC_ID,
  SecretLockTransactionBodyDTO.JSON_PROPERTY_AMOUNT,
  SecretLockTransactionBodyDTO.JSON_PROPERTY_DURATION,
  SecretLockTransactionBodyDTO.JSON_PROPERTY_HASH_ALGORITHM,
  SecretLockTransactionBodyDTO.JSON_PROPERTY_RECIPIENT_ADDRESS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T15:36:44.645Z[UTC]")
public class SecretLockTransactionBodyDTO {
  public static final String JSON_PROPERTY_SECRET = "secret";
  private String secret;

  public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
  private String mosaicId;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private java.math.BigInteger amount = null;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private java.math.BigInteger duration = null;

  public static final String JSON_PROPERTY_HASH_ALGORITHM = "hashAlgorithm";
  private LockHashAlgorithmEnum hashAlgorithm;

  public static final String JSON_PROPERTY_RECIPIENT_ADDRESS = "recipientAddress";
  private String recipientAddress;


  public SecretLockTransactionBodyDTO secret(String secret) {
    
    this.secret = secret;
    return this;
  }

   /**
   * Get secret
   * @return secret
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SECRET)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSecret() {
    return secret;
  }


  public void setSecret(String secret) {
    this.secret = secret;
  }


  public SecretLockTransactionBodyDTO mosaicId(String mosaicId) {
    
    this.mosaicId = mosaicId;
    return this;
  }

   /**
   * Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. 
   * @return mosaicId
  **/
  @ApiModelProperty(example = "85BBEA6CC462B244", required = true, value = "Mosaic identifier. If the most significant bit of byte 0 is set, a namespaceId (alias) is used instead of the real mosaic identifier. ")
  @JsonProperty(JSON_PROPERTY_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMosaicId() {
    return mosaicId;
  }


  public void setMosaicId(String mosaicId) {
    this.mosaicId = mosaicId;
  }


  public SecretLockTransactionBodyDTO amount(java.math.BigInteger amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return amount
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getAmount() {
    return amount;
  }


  public void setAmount(java.math.BigInteger amount) {
    this.amount = amount;
  }


  public SecretLockTransactionBodyDTO duration(java.math.BigInteger duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return duration
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  @JsonProperty(JSON_PROPERTY_DURATION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getDuration() {
    return duration;
  }


  public void setDuration(java.math.BigInteger duration) {
    this.duration = duration;
  }


  public SecretLockTransactionBodyDTO hashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
    
    this.hashAlgorithm = hashAlgorithm;
    return this;
  }

   /**
   * Get hashAlgorithm
   * @return hashAlgorithm
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_HASH_ALGORITHM)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LockHashAlgorithmEnum getHashAlgorithm() {
    return hashAlgorithm;
  }


  public void setHashAlgorithm(LockHashAlgorithmEnum hashAlgorithm) {
    this.hashAlgorithm = hashAlgorithm;
  }


  public SecretLockTransactionBodyDTO recipientAddress(String recipientAddress) {
    
    this.recipientAddress = recipientAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. 
   * @return recipientAddress
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E01A", required = true, value = "Address expressed in hexadecimal base. If the bit 0 of byte 0 is not set (like in 0x90), then it is a regular address. Else (e.g. 0x91) it represents a namespace id which starts at byte 1. ")
  @JsonProperty(JSON_PROPERTY_RECIPIENT_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRecipientAddress() {
    return recipientAddress;
  }


  public void setRecipientAddress(String recipientAddress) {
    this.recipientAddress = recipientAddress;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SecretLockTransactionBodyDTO secretLockTransactionBodyDTO = (SecretLockTransactionBodyDTO) o;
    return Objects.equals(this.secret, secretLockTransactionBodyDTO.secret) &&
        Objects.equals(this.mosaicId, secretLockTransactionBodyDTO.mosaicId) &&
        Objects.equals(this.amount, secretLockTransactionBodyDTO.amount) &&
        Objects.equals(this.duration, secretLockTransactionBodyDTO.duration) &&
        Objects.equals(this.hashAlgorithm, secretLockTransactionBodyDTO.hashAlgorithm) &&
        Objects.equals(this.recipientAddress, secretLockTransactionBodyDTO.recipientAddress);
  }

  @Override
  public int hashCode() {
    return Objects.hash(secret, mosaicId, amount, duration, hashAlgorithm, recipientAddress);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SecretLockTransactionBodyDTO {\n");
    sb.append("    secret: ").append(toIndentedString(secret)).append("\n");
    sb.append("    mosaicId: ").append(toIndentedString(mosaicId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    hashAlgorithm: ").append(toIndentedString(hashAlgorithm)).append("\n");
    sb.append("    recipientAddress: ").append(toIndentedString(recipientAddress)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

