package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsInfoDTO;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-03-09T15:36:44.645Z[UTC]")
public class MosaicRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi delegate;

	public MosaicRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get mosaic information
     * Gets the mosaic definition for a given mosaic identifier.
     * @param mosaicId Mosaic identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaic(String mosaicId, Handler<AsyncResult<MosaicInfoDTO>> resultHandler) {
        delegate.getMosaic(mosaicId, resultHandler);
    }

    /**
     * Get mosaic information
     * Gets the mosaic definition for a given mosaic identifier.
     * @param mosaicId Mosaic identifier. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicInfoDTO> rxGetMosaic(String mosaicId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaic(mosaicId, fut);
        }));
    }
    /**
     * Get mosaics information for an array of mosaics
     * Gets an array of mosaic definition.
     * @param mosaicIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaics(MosaicIds mosaicIds, Handler<AsyncResult<List<MosaicInfoDTO>>> resultHandler) {
        delegate.getMosaics(mosaicIds, resultHandler);
    }

    /**
     * Get mosaics information for an array of mosaics
     * Gets an array of mosaic definition.
     * @param mosaicIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<MosaicInfoDTO>> rxGetMosaics(MosaicIds mosaicIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaics(mosaicIds, fut);
        }));
    }
    /**
     * Get mosaics created by an account
     * Gets an array of mosaics created for a given account address.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicsFromAccount(String accountId, Handler<AsyncResult<MosaicsInfoDTO>> resultHandler) {
        delegate.getMosaicsFromAccount(accountId, resultHandler);
    }

    /**
     * Get mosaics created by an account
     * Gets an array of mosaics created for a given account address.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicsInfoDTO> rxGetMosaicsFromAccount(String accountId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicsFromAccount(accountId, fut);
        }));
    }
    /**
     * Get mosaics created for given array of addresses
     * Gets mosaics created for a given array of addresses.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicsFromAccounts(AccountIds accountIds, Handler<AsyncResult<MosaicsInfoDTO>> resultHandler) {
        delegate.getMosaicsFromAccounts(accountIds, resultHandler);
    }

    /**
     * Get mosaics created for given array of addresses
     * Gets mosaics created for a given array of addresses.
     * @param accountIds  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicsInfoDTO> rxGetMosaicsFromAccounts(AccountIds accountIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicsFromAccounts(accountIds, fut);
        }));
    }

    public static MosaicRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi arg) {
        return arg != null ? new MosaicRoutesApi(arg) : null;
    }
}
