/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

public class MosaicDefinitionTransactionBodyDTO {
    public static final String JSON_PROPERTY_ID = "id";
    @JsonProperty(value="id")
    private String id;
    public static final String JSON_PROPERTY_DURATION = "duration";
    @JsonProperty(value="duration")
    private BigInteger duration = null;
    public static final String JSON_PROPERTY_NONCE = "nonce";
    @JsonProperty(value="nonce")
    private Long nonce;
    public static final String JSON_PROPERTY_FLAGS = "flags";
    @JsonProperty(value="flags")
    private Integer flags;
    public static final String JSON_PROPERTY_DIVISIBILITY = "divisibility";
    @JsonProperty(value="divisibility")
    private Integer divisibility;

    public MosaicDefinitionTransactionBodyDTO id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="0DC67FBE1CAD29E3", required=true, value="Mosaic identifier.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MosaicDefinitionTransactionBodyDTO duration(BigInteger duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="200", required=true, value="Duration expressed in number of blocks.")
    public BigInteger getDuration() {
        return this.duration;
    }

    public void setDuration(BigInteger duration) {
        this.duration = duration;
    }

    public MosaicDefinitionTransactionBodyDTO nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @ApiModelProperty(example="0", required=true, value="Random nonce used to generate the mosaic id.")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public MosaicDefinitionTransactionBodyDTO flags(Integer flags) {
        this.flags = flags;
        return this;
    }

    @ApiModelProperty(required=true, value="- 0x00 (none) - No flags present. - 0x01 (supplyMutable) - Mosaic supports supply changes even when mosaic owner owns partial supply. - 0x02 (transferable) - Mosaic supports transfers between arbitrary accounts. When not set, mosaic can only be transferred to and from mosaic owner. - 0x04 (restrictable) - Mosaic supports custom restrictions configured by mosaic owner. ")
    public Integer getFlags() {
        return this.flags;
    }

    public void setFlags(Integer flags) {
        this.flags = flags;
    }

    public MosaicDefinitionTransactionBodyDTO divisibility(Integer divisibility) {
        this.divisibility = divisibility;
        return this;
    }

    @ApiModelProperty(required=true, value="Determines up to what decimal place the mosaic can be divided. Divisibility of 3 means that a mosaic can be divided into smallest parts of 0.001 mosaics. The divisibility must be in the range of 0 and 6. ")
    public Integer getDivisibility() {
        return this.divisibility;
    }

    public void setDivisibility(Integer divisibility) {
        this.divisibility = divisibility;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MosaicDefinitionTransactionBodyDTO mosaicDefinitionTransactionBodyDTO = (MosaicDefinitionTransactionBodyDTO)o;
        return Objects.equals(this.id, mosaicDefinitionTransactionBodyDTO.id) && Objects.equals(this.duration, mosaicDefinitionTransactionBodyDTO.duration) && Objects.equals(this.nonce, mosaicDefinitionTransactionBodyDTO.nonce) && Objects.equals(this.flags, mosaicDefinitionTransactionBodyDTO.flags) && Objects.equals(this.divisibility, mosaicDefinitionTransactionBodyDTO.divisibility);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.duration, this.nonce, this.flags, this.divisibility);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MosaicDefinitionTransactionBodyDTO {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    divisibility: ").append(this.toIndentedString(this.divisibility)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

