/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;

@ApiModel(description="Supplementary data stored for importance recalculation. At each importance recalculation, existing buckets are shifted, the working bucket is finalized and a new working bucketis created. Each bucket influences at most five importance recalculations. ")
public class ActivityBucketDTO {
    public static final String JSON_PROPERTY_START_HEIGHT = "startHeight";
    @JsonProperty(value="startHeight")
    private BigInteger startHeight = null;
    public static final String JSON_PROPERTY_TOTAL_FEES_PAID = "totalFeesPaid";
    @JsonProperty(value="totalFeesPaid")
    private Long totalFeesPaid;
    public static final String JSON_PROPERTY_BENEFICIARY_COUNT = "beneficiaryCount";
    @JsonProperty(value="beneficiaryCount")
    private Integer beneficiaryCount;
    public static final String JSON_PROPERTY_RAW_SCORE = "rawScore";
    @JsonProperty(value="rawScore")
    private Long rawScore;

    public ActivityBucketDTO startHeight(BigInteger startHeight) {
        this.startHeight = startHeight;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="Height of the blockchain.")
    public BigInteger getStartHeight() {
        return this.startHeight;
    }

    public void setStartHeight(BigInteger startHeight) {
        this.startHeight = startHeight;
    }

    public ActivityBucketDTO totalFeesPaid(Long totalFeesPaid) {
        this.totalFeesPaid = totalFeesPaid;
        return this;
    }

    @ApiModelProperty(required=true, value="Fees paid by the account for this bucket.")
    public Long getTotalFeesPaid() {
        return this.totalFeesPaid;
    }

    public void setTotalFeesPaid(Long totalFeesPaid) {
        this.totalFeesPaid = totalFeesPaid;
    }

    public ActivityBucketDTO beneficiaryCount(Integer beneficiaryCount) {
        this.beneficiaryCount = beneficiaryCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Number of times the account has been a beneficiary for this bucket.")
    public Integer getBeneficiaryCount() {
        return this.beneficiaryCount;
    }

    public void setBeneficiaryCount(Integer beneficiaryCount) {
        this.beneficiaryCount = beneficiaryCount;
    }

    public ActivityBucketDTO rawScore(Long rawScore) {
        this.rawScore = rawScore;
        return this;
    }

    @ApiModelProperty(required=true, value="Importance score for this bucket. This is taken into account to calculate the latest account importance.")
    public Long getRawScore() {
        return this.rawScore;
    }

    public void setRawScore(Long rawScore) {
        this.rawScore = rawScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityBucketDTO activityBucketDTO = (ActivityBucketDTO)o;
        return Objects.equals(this.startHeight, activityBucketDTO.startHeight) && Objects.equals(this.totalFeesPaid, activityBucketDTO.totalFeesPaid) && Objects.equals(this.beneficiaryCount, activityBucketDTO.beneficiaryCount) && Objects.equals(this.rawScore, activityBucketDTO.rawScore);
    }

    public int hashCode() {
        return Objects.hash(this.startHeight, this.totalFeesPaid, this.beneficiaryCount, this.rawScore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityBucketDTO {\n");
        sb.append("    startHeight: ").append(this.toIndentedString(this.startHeight)).append("\n");
        sb.append("    totalFeesPaid: ").append(this.toIndentedString(this.totalFeesPaid)).append("\n");
        sb.append("    beneficiaryCount: ").append(this.toIndentedString(this.beneficiaryCount)).append("\n");
        sb.append("    rawScore: ").append(this.toIndentedString(this.rawScore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

