/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.symbol.sdk.openapi.vertx.api.MosaicRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;
import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsInfoDTO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MosaicRoutesApiImpl
implements MosaicRoutesApi {
    private ApiClient apiClient;

    public MosaicRoutesApiImpl() {
        this(null);
    }

    public MosaicRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void getMosaic(String mosaicId, Handler<AsyncResult<MosaicInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaic"));
            return;
        }
        String localVarPath = "/mosaic/{mosaicId}".replaceAll("\\{mosaicId\\}", mosaicId.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MosaicInfoDTO> localVarReturnType = new TypeReference<MosaicInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaics(MosaicIds mosaicIds, Handler<AsyncResult<List<MosaicInfoDTO>>> resultHandler) {
        MosaicIds localVarBody = mosaicIds;
        if (mosaicIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicIds' when calling getMosaics"));
            return;
        }
        String localVarPath = "/mosaic";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<List<MosaicInfoDTO>> localVarReturnType = new TypeReference<List<MosaicInfoDTO>>(){};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaicsFromAccount(String accountId, Handler<AsyncResult<MosaicsInfoDTO>> resultHandler) {
        Object localVarBody = null;
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getMosaicsFromAccount"));
            return;
        }
        String localVarPath = "/account/{accountId}/mosaics".replaceAll("\\{accountId\\}", accountId.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MosaicsInfoDTO> localVarReturnType = new TypeReference<MosaicsInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaicsFromAccounts(AccountIds accountIds, Handler<AsyncResult<MosaicsInfoDTO>> resultHandler) {
        AccountIds localVarBody = accountIds;
        String localVarPath = "/account/mosaics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{"application/json"};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MosaicsInfoDTO> localVarReturnType = new TypeReference<MosaicsInfoDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}

