/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.sdk.openapi.vertx.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.nem.symbol.sdk.openapi.vertx.api.MetadataRoutesApi;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MetadataEntriesDTO;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;

public class MetadataRoutesApiImpl
implements MetadataRoutesApi {
    private ApiClient apiClient;

    public MetadataRoutesApiImpl() {
        this(null);
    }

    public MetadataRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void getAccountMetadata(String accountId, Integer pageSize, String id, String ordering, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountMetadata"));
            return;
        }
        String localVarPath = "/metadata/account/{accountId}".replaceAll("\\{accountId\\}", accountId.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getAccountMetadataByKey(String accountId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountMetadataByKey"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getAccountMetadataByKey"));
            return;
        }
        String localVarPath = "/metadata/account/{accountId}/key/{key}".replaceAll("\\{accountId\\}", accountId.toString()).replaceAll("\\{key\\}", key.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getAccountMetadataByKeyAndSender(String accountId, String key, String publicKey, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        Object localVarBody = null;
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getAccountMetadataByKeyAndSender"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getAccountMetadataByKeyAndSender"));
            return;
        }
        if (publicKey == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'publicKey' when calling getAccountMetadataByKeyAndSender"));
            return;
        }
        String localVarPath = "/metadata/account/{accountId}/key/{key}/sender/{publicKey}".replaceAll("\\{accountId\\}", accountId.toString()).replaceAll("\\{key\\}", key.toString()).replaceAll("\\{publicKey\\}", publicKey.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataDTO> localVarReturnType = new TypeReference<MetadataDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaicMetadata(String mosaicId, Integer pageSize, String id, String ordering, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadata"));
            return;
        }
        String localVarPath = "/metadata/mosaic/{mosaicId}".replaceAll("\\{mosaicId\\}", mosaicId.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaicMetadataByKey(String mosaicId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKey"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKey"));
            return;
        }
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}".replaceAll("\\{mosaicId\\}", mosaicId.toString()).replaceAll("\\{key\\}", key.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getMosaicMetadataByKeyAndSender(String mosaicId, String key, String publicKey, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        Object localVarBody = null;
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaicMetadataByKeyAndSender"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getMosaicMetadataByKeyAndSender"));
            return;
        }
        if (publicKey == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'publicKey' when calling getMosaicMetadataByKeyAndSender"));
            return;
        }
        String localVarPath = "/metadata/mosaic/{mosaicId}/key/{key}/sender/{publicKey}".replaceAll("\\{mosaicId\\}", mosaicId.toString()).replaceAll("\\{key\\}", key.toString()).replaceAll("\\{publicKey\\}", publicKey.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataDTO> localVarReturnType = new TypeReference<MetadataDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getNamespaceMetadata(String namespaceId, Integer pageSize, String id, String ordering, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadata"));
            return;
        }
        String localVarPath = "/metadata/namespace/{namespaceId}".replaceAll("\\{namespaceId\\}", namespaceId.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "pageSize", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "id", id));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ordering", ordering));
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getNamespaceMetadataByKey(String namespaceId, String key, Handler<AsyncResult<MetadataEntriesDTO>> resultHandler) {
        Object localVarBody = null;
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKey"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKey"));
            return;
        }
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}".replaceAll("\\{namespaceId\\}", namespaceId.toString()).replaceAll("\\{key\\}", key.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataEntriesDTO> localVarReturnType = new TypeReference<MetadataEntriesDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }

    @Override
    public void getNamespaceMetadataByKeyAndSender(String namespaceId, String key, String publicKey, Handler<AsyncResult<MetadataDTO>> resultHandler) {
        Object localVarBody = null;
        if (namespaceId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'namespaceId' when calling getNamespaceMetadataByKeyAndSender"));
            return;
        }
        if (key == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'key' when calling getNamespaceMetadataByKeyAndSender"));
            return;
        }
        if (publicKey == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'publicKey' when calling getNamespaceMetadataByKeyAndSender"));
            return;
        }
        String localVarPath = "/metadata/namespace/{namespaceId}/key/{key}/sender/{publicKey}".replaceAll("\\{namespaceId\\}", namespaceId.toString()).replaceAll("\\{key\\}", key.toString()).replaceAll("\\{publicKey\\}", publicKey.toString());
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String[] localVarContentTypes = new String[]{};
        String[] localVarAuthNames = new String[]{};
        TypeReference<MetadataDTO> localVarReturnType = new TypeReference<MetadataDTO>(){};
        this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}

