/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 1.0.20.19
 *
 * The version of the OpenAPI document: 0.8.5
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.AccountAddressRestrictionTransactionBodyDTO;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionFlagsEnum;
import io.nem.symbol.sdk.openapi.vertx.model.NetworkTypeEnum;
import io.nem.symbol.sdk.openapi.vertx.model.TransactionDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

/**
 * Transaction to prevent incoming and outgoing transactions for a given a set of addresses.
 */
@ApiModel(description = "Transaction to prevent incoming and outgoing transactions for a given a set of addresses.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-24T09:41:08.253Z[UTC]")
public class AccountAddressRestrictionTransactionDTO {
  public static final String JSON_PROPERTY_SIGNATURE = "signature";
  @JsonProperty(JSON_PROPERTY_SIGNATURE)
  private String signature;

  public static final String JSON_PROPERTY_SIGNER_PUBLIC_KEY = "signerPublicKey";
  @JsonProperty(JSON_PROPERTY_SIGNER_PUBLIC_KEY)
  private String signerPublicKey;

  public static final String JSON_PROPERTY_VERSION = "version";
  @JsonProperty(JSON_PROPERTY_VERSION)
  private Integer version;

  public static final String JSON_PROPERTY_NETWORK = "network";
  @JsonProperty(JSON_PROPERTY_NETWORK)
  private NetworkTypeEnum network;

  public static final String JSON_PROPERTY_TYPE = "type";
  @JsonProperty(JSON_PROPERTY_TYPE)
  private Integer type;

  public static final String JSON_PROPERTY_MAX_FEE = "maxFee";
  @JsonProperty(JSON_PROPERTY_MAX_FEE)
  private java.math.BigInteger maxFee = null;

  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  private java.math.BigInteger deadline = null;

  public static final String JSON_PROPERTY_RESTRICTION_FLAGS = "restrictionFlags";
  @JsonProperty(JSON_PROPERTY_RESTRICTION_FLAGS)
  private AccountRestrictionFlagsEnum restrictionFlags;

  public static final String JSON_PROPERTY_RESTRICTION_ADDITIONS = "restrictionAdditions";
  @JsonProperty(JSON_PROPERTY_RESTRICTION_ADDITIONS)
  private List<String> restrictionAdditions = new ArrayList<>();

  public static final String JSON_PROPERTY_RESTRICTION_DELETIONS = "restrictionDeletions";
  @JsonProperty(JSON_PROPERTY_RESTRICTION_DELETIONS)
  private List<String> restrictionDeletions = new ArrayList<>();

  public AccountAddressRestrictionTransactionDTO signature(String signature) {
    this.signature = signature;
    return this;
  }

   /**
   * Entity&#39;s signature generated by the signer.
   * @return signature
  **/
  @ApiModelProperty(example = "4B408BBEDF25F2AC8E0E44A6E51E3CCBA03885902055F75EB9FF50433532CA44BF9175FDA7502EEE2FC1617126E453A2BD692BAFDAAF06BC8EDEBA7961B3730D", required = true, value = "Entity's signature generated by the signer.")
  public String getSignature() {
    return signature;
  }

  public void setSignature(String signature) {
    this.signature = signature;
  }

  public AccountAddressRestrictionTransactionDTO signerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
    return this;
  }

   /**
   * Public key.
   * @return signerPublicKey
  **/
  @ApiModelProperty(example = "AC1A6E1D8DE5B17D2C6B1293F1CAD3829EEACF38D09311BB3C8E5A880092DE26", required = true, value = "Public key.")
  public String getSignerPublicKey() {
    return signerPublicKey;
  }

  public void setSignerPublicKey(String signerPublicKey) {
    this.signerPublicKey = signerPublicKey;
  }

  public AccountAddressRestrictionTransactionDTO version(Integer version) {
    this.version = version;
    return this;
  }

   /**
   * Entity version.
   * @return version
  **/
  @ApiModelProperty(required = true, value = "Entity version.")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public AccountAddressRestrictionTransactionDTO network(NetworkTypeEnum network) {
    this.network = network;
    return this;
  }

   /**
   * Get network
   * @return network
  **/
  @ApiModelProperty(required = true, value = "")
  public NetworkTypeEnum getNetwork() {
    return network;
  }

  public void setNetwork(NetworkTypeEnum network) {
    this.network = network;
  }

  public AccountAddressRestrictionTransactionDTO type(Integer type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public AccountAddressRestrictionTransactionDTO maxFee(java.math.BigInteger maxFee) {
    this.maxFee = maxFee;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return maxFee
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  public java.math.BigInteger getMaxFee() {
    return maxFee;
  }

  public void setMaxFee(java.math.BigInteger maxFee) {
    this.maxFee = maxFee;
  }

  public AccountAddressRestrictionTransactionDTO deadline(java.math.BigInteger deadline) {
    this.deadline = deadline;
    return this;
  }

   /**
   * Duration expressed in number of blocks.
   * @return deadline
  **/
  @ApiModelProperty(example = "200", required = true, value = "Duration expressed in number of blocks.")
  public java.math.BigInteger getDeadline() {
    return deadline;
  }

  public void setDeadline(java.math.BigInteger deadline) {
    this.deadline = deadline;
  }

  public AccountAddressRestrictionTransactionDTO restrictionFlags(AccountRestrictionFlagsEnum restrictionFlags) {
    this.restrictionFlags = restrictionFlags;
    return this;
  }

   /**
   * Get restrictionFlags
   * @return restrictionFlags
  **/
  @ApiModelProperty(required = true, value = "")
  public AccountRestrictionFlagsEnum getRestrictionFlags() {
    return restrictionFlags;
  }

  public void setRestrictionFlags(AccountRestrictionFlagsEnum restrictionFlags) {
    this.restrictionFlags = restrictionFlags;
  }

  public AccountAddressRestrictionTransactionDTO restrictionAdditions(List<String> restrictionAdditions) {
    this.restrictionAdditions = restrictionAdditions;
    return this;
  }

  public AccountAddressRestrictionTransactionDTO addRestrictionAdditionsItem(String restrictionAdditionsItem) {
    this.restrictionAdditions.add(restrictionAdditionsItem);
    return this;
  }

   /**
   * Account restriction additions.
   * @return restrictionAdditions
  **/
  @ApiModelProperty(required = true, value = "Account restriction additions.")
  public List<String> getRestrictionAdditions() {
    return restrictionAdditions;
  }

  public void setRestrictionAdditions(List<String> restrictionAdditions) {
    this.restrictionAdditions = restrictionAdditions;
  }

  public AccountAddressRestrictionTransactionDTO restrictionDeletions(List<String> restrictionDeletions) {
    this.restrictionDeletions = restrictionDeletions;
    return this;
  }

  public AccountAddressRestrictionTransactionDTO addRestrictionDeletionsItem(String restrictionDeletionsItem) {
    this.restrictionDeletions.add(restrictionDeletionsItem);
    return this;
  }

   /**
   * Account restriction deletions.
   * @return restrictionDeletions
  **/
  @ApiModelProperty(required = true, value = "Account restriction deletions.")
  public List<String> getRestrictionDeletions() {
    return restrictionDeletions;
  }

  public void setRestrictionDeletions(List<String> restrictionDeletions) {
    this.restrictionDeletions = restrictionDeletions;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AccountAddressRestrictionTransactionDTO accountAddressRestrictionTransactionDTO = (AccountAddressRestrictionTransactionDTO) o;
    return Objects.equals(this.signature, accountAddressRestrictionTransactionDTO.signature) &&
        Objects.equals(this.signerPublicKey, accountAddressRestrictionTransactionDTO.signerPublicKey) &&
        Objects.equals(this.version, accountAddressRestrictionTransactionDTO.version) &&
        Objects.equals(this.network, accountAddressRestrictionTransactionDTO.network) &&
        Objects.equals(this.type, accountAddressRestrictionTransactionDTO.type) &&
        Objects.equals(this.maxFee, accountAddressRestrictionTransactionDTO.maxFee) &&
        Objects.equals(this.deadline, accountAddressRestrictionTransactionDTO.deadline) &&
        Objects.equals(this.restrictionFlags, accountAddressRestrictionTransactionDTO.restrictionFlags) &&
        Objects.equals(this.restrictionAdditions, accountAddressRestrictionTransactionDTO.restrictionAdditions) &&
        Objects.equals(this.restrictionDeletions, accountAddressRestrictionTransactionDTO.restrictionDeletions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(signature, signerPublicKey, version, network, type, maxFee, deadline, restrictionFlags, restrictionAdditions, restrictionDeletions);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AccountAddressRestrictionTransactionDTO {\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("    signerPublicKey: ").append(toIndentedString(signerPublicKey)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    network: ").append(toIndentedString(network)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    maxFee: ").append(toIndentedString(maxFee)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    restrictionFlags: ").append(toIndentedString(restrictionFlags)).append("\n");
    sb.append("    restrictionAdditions: ").append(toIndentedString(restrictionAdditions)).append("\n");
    sb.append("    restrictionDeletions: ").append(toIndentedString(restrictionDeletions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

