package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicAddressRestrictionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicGlobalRestrictionDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-24T09:41:08.253Z[UTC]")
public class RestrictionMosaicRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi delegate;

	public RestrictionMosaicRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get mosaic address restrictions for a given mosaic and account identifier.
     * Get mosaic address restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicAddressRestriction(String mosaicId, String accountId, Handler<AsyncResult<MosaicAddressRestrictionDTO>> resultHandler) {
        delegate.getMosaicAddressRestriction(mosaicId, accountId, resultHandler);
    }

    /**
     * Get mosaic address restrictions for a given mosaic and account identifier.
     * Get mosaic address restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicAddressRestrictionDTO> rxGetMosaicAddressRestriction(String mosaicId, String accountId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicAddressRestriction(mosaicId, accountId, fut);
        }));
    }
    /**
     * Get mosaic address restrictions for a given mosaic and account identifiers array.
     * Get mosaic address restrictions.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicAddressRestrictions(String mosaicId, AccountIds accountIds, Handler<AsyncResult<List<MosaicAddressRestrictionDTO>>> resultHandler) {
        delegate.getMosaicAddressRestrictions(mosaicId, accountIds, resultHandler);
    }

    /**
     * Get mosaic address restrictions for a given mosaic and account identifiers array.
     * Get mosaic address restrictions.
     * @param mosaicId Mosaic identifier. (required)
     * @param accountIds  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<MosaicAddressRestrictionDTO>> rxGetMosaicAddressRestrictions(String mosaicId, AccountIds accountIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicAddressRestrictions(mosaicId, accountIds, fut);
        }));
    }
    /**
     * Get mosaic global restriction for a given mosaic identifier.
     * Get mosaic global restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicGlobalRestriction(String mosaicId, Handler<AsyncResult<MosaicGlobalRestrictionDTO>> resultHandler) {
        delegate.getMosaicGlobalRestriction(mosaicId, resultHandler);
    }

    /**
     * Get mosaic global restriction for a given mosaic identifier.
     * Get mosaic global restriction.
     * @param mosaicId Mosaic identifier. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<MosaicGlobalRestrictionDTO> rxGetMosaicGlobalRestriction(String mosaicId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicGlobalRestriction(mosaicId, fut);
        }));
    }
    /**
     * Get mosaic global restrictions for an array of mosaics.
     * Get mosaic global restrictions.
     * @param mosaicIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicGlobalRestrictions(MosaicIds mosaicIds, Handler<AsyncResult<List<MosaicGlobalRestrictionDTO>>> resultHandler) {
        delegate.getMosaicGlobalRestrictions(mosaicIds, resultHandler);
    }

    /**
     * Get mosaic global restrictions for an array of mosaics.
     * Get mosaic global restrictions.
     * @param mosaicIds  (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<MosaicGlobalRestrictionDTO>> rxGetMosaicGlobalRestrictions(MosaicIds mosaicIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getMosaicGlobalRestrictions(mosaicIds, fut);
        }));
    }

    public static RestrictionMosaicRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.RestrictionMosaicRoutesApi arg) {
        return arg != null ? new RestrictionMosaicRoutesApi(arg) : null;
    }
}
