package io.nem.symbol.sdk.openapi.vertx.api.rxjava;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.AccountRestrictionsInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;

import java.util.*;

import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-24T09:41:08.253Z[UTC]")
public class RestrictionAccountRoutesApi {

	private final io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi delegate;

	public RestrictionAccountRoutesApi(io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi delegate) {
	    this.delegate = delegate;
    }

	public io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi getDelegate() {
	    return delegate;
	}

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given account.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountRestrictions(String accountId, Handler<AsyncResult<AccountRestrictionsInfoDTO>> resultHandler) {
        delegate.getAccountRestrictions(accountId, resultHandler);
    }

    /**
     * Get the account restrictions
     * Returns the account restrictions for a given account.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<AccountRestrictionsInfoDTO> rxGetAccountRestrictions(String accountId) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountRestrictions(accountId, fut);
        }));
    }
    /**
     * Get account restrictions for given array of addresses
     * Returns the account restrictions for a given array of addresses.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getAccountRestrictionsFromAccounts(AccountIds accountIds, Handler<AsyncResult<List<AccountRestrictionsInfoDTO>>> resultHandler) {
        delegate.getAccountRestrictionsFromAccounts(accountIds, resultHandler);
    }

    /**
     * Get account restrictions for given array of addresses
     * Returns the account restrictions for a given array of addresses.
     * @param accountIds  (optional)
     * @return Asynchronous result handler (RxJava Single)
     */
    public Single<List<AccountRestrictionsInfoDTO>> rxGetAccountRestrictionsFromAccounts(AccountIds accountIds) {
        return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
            delegate.getAccountRestrictionsFromAccounts(accountIds, fut);
        }));
    }

    public static RestrictionAccountRoutesApi newInstance(io.nem.symbol.sdk.openapi.vertx.api.RestrictionAccountRoutesApi arg) {
        return arg != null ? new RestrictionAccountRoutesApi(arg) : null;
    }
}
