package io.nem.symbol.sdk.openapi.vertx.api;

import io.nem.symbol.sdk.openapi.vertx.model.AccountIds;
import io.nem.symbol.sdk.openapi.vertx.model.ModelError;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicIds;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicInfoDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MosaicsInfoDTO;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;

import com.fasterxml.jackson.core.type.TypeReference;

import java.util.*;

import io.nem.symbol.sdk.openapi.vertx.invoker.ApiClient;
import io.nem.symbol.sdk.openapi.vertx.invoker.ApiException;
import io.nem.symbol.sdk.openapi.vertx.invoker.Configuration;
import io.nem.symbol.sdk.openapi.vertx.invoker.Pair;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-02-24T09:41:08.253Z[UTC]")
public class MosaicRoutesApiImpl implements MosaicRoutesApi {

    private ApiClient apiClient;

    public MosaicRoutesApiImpl() {
        this(null);
    }

    public MosaicRoutesApiImpl(ApiClient apiClient) {
        this.apiClient = apiClient != null ? apiClient : Configuration.getDefaultApiClient();
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Get mosaic information
     * Gets the mosaic definition for a given mosaic identifier.
     * @param mosaicId Mosaic identifier. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaic(String mosaicId, Handler<AsyncResult<MosaicInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'mosaicId' is set
        if (mosaicId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicId' when calling getMosaic"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/mosaic/{mosaicId}".replaceAll("\\{" + "mosaicId" + "\\}", mosaicId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MosaicInfoDTO> localVarReturnType = new TypeReference<MosaicInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get mosaics information for an array of mosaics
     * Gets an array of mosaic definition.
     * @param mosaicIds  (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaics(MosaicIds mosaicIds, Handler<AsyncResult<List<MosaicInfoDTO>>> resultHandler) {
        Object localVarBody = mosaicIds;
        
        // verify the required parameter 'mosaicIds' is set
        if (mosaicIds == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'mosaicIds' when calling getMosaics"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/mosaic";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<List<MosaicInfoDTO>> localVarReturnType = new TypeReference<List<MosaicInfoDTO>>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get mosaics created by an account
     * Gets an array of mosaics created for a given account address.
     * @param accountId Account public key or address enconded using a 32-character set. (required)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicsFromAccount(String accountId, Handler<AsyncResult<MosaicsInfoDTO>> resultHandler) {
        Object localVarBody = null;
        
        // verify the required parameter 'accountId' is set
        if (accountId == null) {
            resultHandler.handle(ApiException.fail(400, "Missing the required parameter 'accountId' when calling getMosaicsFromAccount"));
            return;
        }
        
        // create path and map variables
        String localVarPath = "/account/{accountId}/mosaics".replaceAll("\\{" + "accountId" + "\\}", accountId.toString());

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = {  };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MosaicsInfoDTO> localVarReturnType = new TypeReference<MosaicsInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
    /**
     * Get mosaics created for given array of addresses
     * Gets mosaics created for a given array of addresses.
     * @param accountIds  (optional)
     * @param resultHandler Asynchronous result handler
     */
    public void getMosaicsFromAccounts(AccountIds accountIds, Handler<AsyncResult<MosaicsInfoDTO>> resultHandler) {
        Object localVarBody = accountIds;
        
        // create path and map variables
        String localVarPath = "/account/mosaics";

        // query params
        List<Pair> localVarQueryParams = new ArrayList<>();

        // header params
        MultiMap localVarHeaderParams = MultiMap.caseInsensitiveMultiMap();
        
        // form params
        // TODO: sending files within multipart/form-data is not supported yet (because of vertx web-client)
        Map<String, Object> localVarFormParams = new HashMap<>();
        
        String[] localVarAccepts = { "application/json" };
        String[] localVarContentTypes = { "application/json" };
        String[] localVarAuthNames = new String[] {  };
        TypeReference<MosaicsInfoDTO> localVarReturnType = new TypeReference<MosaicsInfoDTO>() {};
        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarBody, localVarHeaderParams, localVarFormParams, localVarAccepts, localVarContentTypes, localVarAuthNames, localVarReturnType, resultHandler);
    }
}
