/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.3.0
 *
 * The version of the OpenAPI document: 0.11.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleTreeBranchLinkDTO;
import io.nem.symbol.sdk.openapi.vertx.model.MerkleTreeNodeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Merkle tree branch node.
 */
@ApiModel(description = "Merkle tree branch node.")
@JsonPropertyOrder({
  MerkleTreeBranchDTO.JSON_PROPERTY_TYPE,
  MerkleTreeBranchDTO.JSON_PROPERTY_PATH,
  MerkleTreeBranchDTO.JSON_PROPERTY_ENCODED_PATH,
  MerkleTreeBranchDTO.JSON_PROPERTY_NIBBLE_COUNT,
  MerkleTreeBranchDTO.JSON_PROPERTY_LINK_MASK,
  MerkleTreeBranchDTO.JSON_PROPERTY_LINKS,
  MerkleTreeBranchDTO.JSON_PROPERTY_BRANCH_HASH
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T22:22:33.231Z[UTC]")
public class MerkleTreeBranchDTO {
  public static final String JSON_PROPERTY_TYPE = "type";
  private MerkleTreeNodeTypeEnum type;

  public static final String JSON_PROPERTY_PATH = "path";
  private String path;

  public static final String JSON_PROPERTY_ENCODED_PATH = "encodedPath";
  private String encodedPath;

  public static final String JSON_PROPERTY_NIBBLE_COUNT = "nibbleCount";
  private Integer nibbleCount;

  public static final String JSON_PROPERTY_LINK_MASK = "linkMask";
  private String linkMask;

  public static final String JSON_PROPERTY_LINKS = "links";
  private List<MerkleTreeBranchLinkDTO> links = new ArrayList<>();

  public static final String JSON_PROPERTY_BRANCH_HASH = "branchHash";
  private String branchHash;


  public MerkleTreeBranchDTO type(MerkleTreeNodeTypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_TYPE)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MerkleTreeNodeTypeEnum getType() {
    return type;
  }


  public void setType(MerkleTreeNodeTypeEnum type) {
    this.type = type;
  }


  public MerkleTreeBranchDTO path(String path) {
    
    this.path = path;
    return this;
  }

   /**
   * Branch link path.
   * @return path
  **/
  @ApiModelProperty(required = true, value = "Branch link path.")
  @JsonProperty(JSON_PROPERTY_PATH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPath() {
    return path;
  }


  public void setPath(String path) {
    this.path = path;
  }


  public MerkleTreeBranchDTO encodedPath(String encodedPath) {
    
    this.encodedPath = encodedPath;
    return this;
  }

   /**
   * Encoded branch link path.
   * @return encodedPath
  **/
  @ApiModelProperty(required = true, value = "Encoded branch link path.")
  @JsonProperty(JSON_PROPERTY_ENCODED_PATH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEncodedPath() {
    return encodedPath;
  }


  public void setEncodedPath(String encodedPath) {
    this.encodedPath = encodedPath;
  }


  public MerkleTreeBranchDTO nibbleCount(Integer nibbleCount) {
    
    this.nibbleCount = nibbleCount;
    return this;
  }

   /**
   * Nibble count.
   * @return nibbleCount
  **/
  @ApiModelProperty(required = true, value = "Nibble count.")
  @JsonProperty(JSON_PROPERTY_NIBBLE_COUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getNibbleCount() {
    return nibbleCount;
  }


  public void setNibbleCount(Integer nibbleCount) {
    this.nibbleCount = nibbleCount;
  }


  public MerkleTreeBranchDTO linkMask(String linkMask) {
    
    this.linkMask = linkMask;
    return this;
  }

   /**
   * Branch link bitmask.
   * @return linkMask
  **/
  @ApiModelProperty(required = true, value = "Branch link bitmask.")
  @JsonProperty(JSON_PROPERTY_LINK_MASK)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLinkMask() {
    return linkMask;
  }


  public void setLinkMask(String linkMask) {
    this.linkMask = linkMask;
  }


  public MerkleTreeBranchDTO links(List<MerkleTreeBranchLinkDTO> links) {
    
    this.links = links;
    return this;
  }

  public MerkleTreeBranchDTO addLinksItem(MerkleTreeBranchLinkDTO linksItem) {
    this.links.add(linksItem);
    return this;
  }

   /**
   * Branch links (max 16).
   * @return links
  **/
  @ApiModelProperty(required = true, value = "Branch links (max 16).")
  @JsonProperty(JSON_PROPERTY_LINKS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<MerkleTreeBranchLinkDTO> getLinks() {
    return links;
  }


  public void setLinks(List<MerkleTreeBranchLinkDTO> links) {
    this.links = links;
  }


  public MerkleTreeBranchDTO branchHash(String branchHash) {
    
    this.branchHash = branchHash;
    return this;
  }

   /**
   * Get branchHash
   * @return branchHash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_BRANCH_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBranchHash() {
    return branchHash;
  }


  public void setBranchHash(String branchHash) {
    this.branchHash = branchHash;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MerkleTreeBranchDTO merkleTreeBranchDTO = (MerkleTreeBranchDTO) o;
    return Objects.equals(this.type, merkleTreeBranchDTO.type) &&
        Objects.equals(this.path, merkleTreeBranchDTO.path) &&
        Objects.equals(this.encodedPath, merkleTreeBranchDTO.encodedPath) &&
        Objects.equals(this.nibbleCount, merkleTreeBranchDTO.nibbleCount) &&
        Objects.equals(this.linkMask, merkleTreeBranchDTO.linkMask) &&
        Objects.equals(this.links, merkleTreeBranchDTO.links) &&
        Objects.equals(this.branchHash, merkleTreeBranchDTO.branchHash);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, path, encodedPath, nibbleCount, linkMask, links, branchHash);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MerkleTreeBranchDTO {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    encodedPath: ").append(toIndentedString(encodedPath)).append("\n");
    sb.append("    nibbleCount: ").append(toIndentedString(nibbleCount)).append("\n");
    sb.append("    linkMask: ").append(toIndentedString(linkMask)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    branchHash: ").append(toIndentedString(branchHash)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

