/*
 * Catapult REST Endpoints
 * OpenAPI Specification of catapult-rest 2.3.0
 *
 * The version of the OpenAPI document: 0.11.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.nem.symbol.sdk.openapi.vertx.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.nem.symbol.sdk.openapi.vertx.model.LockStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * HashLockEntryDTO
 */
@JsonPropertyOrder({
  HashLockEntryDTO.JSON_PROPERTY_VERSION,
  HashLockEntryDTO.JSON_PROPERTY_OWNER_ADDRESS,
  HashLockEntryDTO.JSON_PROPERTY_MOSAIC_ID,
  HashLockEntryDTO.JSON_PROPERTY_AMOUNT,
  HashLockEntryDTO.JSON_PROPERTY_END_HEIGHT,
  HashLockEntryDTO.JSON_PROPERTY_STATUS,
  HashLockEntryDTO.JSON_PROPERTY_HASH
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-01-14T22:22:33.231Z[UTC]")
public class HashLockEntryDTO {
  public static final String JSON_PROPERTY_VERSION = "version";
  private Integer version;

  public static final String JSON_PROPERTY_OWNER_ADDRESS = "ownerAddress";
  private String ownerAddress;

  public static final String JSON_PROPERTY_MOSAIC_ID = "mosaicId";
  private String mosaicId;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private java.math.BigInteger amount = null;

  public static final String JSON_PROPERTY_END_HEIGHT = "endHeight";
  private java.math.BigInteger endHeight = null;

  public static final String JSON_PROPERTY_STATUS = "status";
  private LockStatus status;

  public static final String JSON_PROPERTY_HASH = "hash";
  private String hash;


  public HashLockEntryDTO version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * The version of the state
   * @return version
  **/
  @ApiModelProperty(example = "1", required = true, value = "The version of the state")
  @JsonProperty(JSON_PROPERTY_VERSION)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public HashLockEntryDTO ownerAddress(String ownerAddress) {
    
    this.ownerAddress = ownerAddress;
    return this;
  }

   /**
   * Address expressed in hexadecimal base.
   * @return ownerAddress
  **/
  @ApiModelProperty(example = "9081FCCB41F8C8409A9B99E485E0E28D23BD6304EF7215E0", required = true, value = "Address expressed in hexadecimal base.")
  @JsonProperty(JSON_PROPERTY_OWNER_ADDRESS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerAddress() {
    return ownerAddress;
  }


  public void setOwnerAddress(String ownerAddress) {
    this.ownerAddress = ownerAddress;
  }


  public HashLockEntryDTO mosaicId(String mosaicId) {
    
    this.mosaicId = mosaicId;
    return this;
  }

   /**
   * Mosaic identifier.
   * @return mosaicId
  **/
  @ApiModelProperty(example = "0DC67FBE1CAD29E3", required = true, value = "Mosaic identifier.")
  @JsonProperty(JSON_PROPERTY_MOSAIC_ID)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMosaicId() {
    return mosaicId;
  }


  public void setMosaicId(String mosaicId) {
    this.mosaicId = mosaicId;
  }


  public HashLockEntryDTO amount(java.math.BigInteger amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).
   * @return amount
  **/
  @ApiModelProperty(example = "123456", required = true, value = "Absolute amount. An amount of 123456789 (absolute) for a mosaic with divisibility 6 means 123.456789 (relative).")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getAmount() {
    return amount;
  }


  public void setAmount(java.math.BigInteger amount) {
    this.amount = amount;
  }


  public HashLockEntryDTO endHeight(java.math.BigInteger endHeight) {
    
    this.endHeight = endHeight;
    return this;
  }

   /**
   * Height of the blockchain.
   * @return endHeight
  **/
  @ApiModelProperty(example = "1", required = true, value = "Height of the blockchain.")
  @JsonProperty(JSON_PROPERTY_END_HEIGHT)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public java.math.BigInteger getEndHeight() {
    return endHeight;
  }


  public void setEndHeight(java.math.BigInteger endHeight) {
    this.endHeight = endHeight;
  }


  public HashLockEntryDTO status(LockStatus status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_STATUS)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LockStatus getStatus() {
    return status;
  }


  public void setStatus(LockStatus status) {
    this.status = status;
  }


  public HashLockEntryDTO hash(String hash) {
    
    this.hash = hash;
    return this;
  }

   /**
   * Get hash
   * @return hash
  **/
  @ApiModelProperty(example = "C8FC3FB54FDDFBCE0E8C71224990124E4EEC5AD5D30E592EDFA9524669A23810", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_HASH)
  // @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getHash() {
    return hash;
  }


  public void setHash(String hash) {
    this.hash = hash;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HashLockEntryDTO hashLockEntryDTO = (HashLockEntryDTO) o;
    return Objects.equals(this.version, hashLockEntryDTO.version) &&
        Objects.equals(this.ownerAddress, hashLockEntryDTO.ownerAddress) &&
        Objects.equals(this.mosaicId, hashLockEntryDTO.mosaicId) &&
        Objects.equals(this.amount, hashLockEntryDTO.amount) &&
        Objects.equals(this.endHeight, hashLockEntryDTO.endHeight) &&
        Objects.equals(this.status, hashLockEntryDTO.status) &&
        Objects.equals(this.hash, hashLockEntryDTO.hash);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, ownerAddress, mosaicId, amount, endHeight, status, hash);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HashLockEntryDTO {\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    ownerAddress: ").append(toIndentedString(ownerAddress)).append("\n");
    sb.append("    mosaicId: ").append(toIndentedString(mosaicId)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    endHeight: ").append(toIndentedString(endHeight)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    hash: ").append(toIndentedString(hash)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

